/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.IOException;
import org.junit.Assert;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.PageCacheLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.PageCacheNumberArrayConcurrencyTest;

public class PageCacheLongArrayConcurrencyTest
extends PageCacheNumberArrayConcurrencyTest {
    @Override
    protected Runnable wholeFileRacer(NumberArray array, int contestant) {
        return new WholeFileRacer((LongArray)((PageCacheLongArray)array));
    }

    @Override
    protected Runnable fileRangeRacer(NumberArray array, int contestant) {
        return new FileRangeRacer((LongArray)((PageCacheLongArray)array), contestant);
    }

    protected PageCacheLongArray getNumberArray(PagedFile file) throws IOException {
        return new PageCacheLongArray(file, 100L, 0L, 0L);
    }

    private class FileRangeRacer
    implements Runnable {
        private LongArray array;
        private int contestant;

        FileRangeRacer(LongArray array, int contestant) {
            this.array = array;
            this.contestant = contestant;
        }

        @Override
        public void run() {
            for (int o = 0; o < 2000; ++o) {
                for (long i = (long)this.contestant; i < 100L; i += 10L) {
                    long value = PageCacheLongArrayConcurrencyTest.this.random.nextLong();
                    this.array.set(i, value);
                    Assert.assertEquals((long)value, (long)this.array.get(i));
                }
            }
        }
    }

    private class WholeFileRacer
    implements Runnable {
        private LongArray array;

        WholeFileRacer(LongArray array) {
            this.array = array;
        }

        @Override
        public void run() {
            for (int o = 0; o < 2000; ++o) {
                for (long i = 0L; i < 100L; ++i) {
                    this.array.set(i, i);
                    Assert.assertEquals((long)i, (long)this.array.get(i));
                }
            }
        }
    }
}

