/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.kernel.impl.util.collection.ContinuableArrayCursor;

public class ContinuableArrayCursorTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void shouldNotReturnAnyElementOnEmptySupplier() {
        ContinuableArrayCursor cursor = new ContinuableArrayCursor(() -> null);
        Assert.assertFalse((boolean)cursor.next());
    }

    @Test
    public void shouldNotReturnAnyElementOnSupplierWithOneEmptyArray() {
        ContinuableArrayCursor cursor = new ContinuableArrayCursor(this.supply(new Integer[0]));
        Assert.assertFalse((boolean)cursor.next());
    }

    @Test
    public void shouldMoveCursorOverSingleArray() {
        Integer[] array = new Integer[]{1, 2, 3};
        ContinuableArrayCursor cursor = new ContinuableArrayCursor(this.supply(array));
        this.assertCursor(cursor, new Object[][]{array});
    }

    @Test
    public void shouldMoveCursorOverMultipleArrays() {
        Object[][] arrays = new Integer[][]{{1, 2, 3}, {4, 5, 6}, {7}};
        ContinuableArrayCursor cursor = new ContinuableArrayCursor(this.supply((Integer[][])arrays));
        this.assertCursor(cursor, arrays);
    }

    @Test
    public void callGetBeforeNextShouldThrowIllegalStateException() {
        ContinuableArrayCursor cursor = new ContinuableArrayCursor(this.supply(new Integer[0]));
        this.thrown.expect(IllegalStateException.class);
        cursor.get();
    }

    @Test
    public void callGetAfterNextReturnsFalseShouldThrowIllegalStateException() {
        ContinuableArrayCursor cursor = new ContinuableArrayCursor(this.supply(new Integer[0]));
        Assert.assertFalse((boolean)cursor.next());
        this.thrown.expect(IllegalStateException.class);
        cursor.get();
    }

    private Supplier<Integer[]> supply(Integer[] array) {
        return this.supply(new Integer[][]{array});
    }

    private Supplier<Integer[]> supply(Integer[][] arrays) {
        Iterator iterator = Arrays.asList(arrays).iterator();
        return () -> iterator.hasNext() ? (Integer[])iterator.next() : null;
    }

    private void assertCursor(ContinuableArrayCursor<?> cursor, Object[] ... arrays) {
        Object[][] objectArray = arrays;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] array;
            for (Object obj : array = objectArray[i]) {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((Object)obj, (Object)cursor.get());
            }
        }
        Assert.assertFalse((boolean)cursor.next());
    }
}

