/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.scheduler.JobScheduler;

public class CountingJobScheduler
implements JobScheduler {
    private final AtomicInteger counter;
    private final CentralJobScheduler delegate;

    public CountingJobScheduler(AtomicInteger counter, CentralJobScheduler delegate) {
        this.counter = counter;
        this.delegate = delegate;
    }

    public void setTopLevelGroupName(String name) {
        this.delegate.setTopLevelGroupName(name);
    }

    public Executor executor(JobScheduler.Group group) {
        return this.delegate.executor(group);
    }

    public ThreadFactory threadFactory(JobScheduler.Group group) {
        return this.delegate.threadFactory(group);
    }

    public ExecutorService workStealingExecutor(JobScheduler.Group group, int parallelism) {
        return this.delegate.workStealingExecutor(group, parallelism);
    }

    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job) {
        this.counter.getAndIncrement();
        return this.delegate.schedule(group, job);
    }

    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable runnable, long initialDelay, TimeUnit timeUnit) {
        this.counter.getAndIncrement();
        return this.delegate.schedule(group, runnable, initialDelay, timeUnit);
    }

    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        this.counter.getAndIncrement();
        return this.delegate.scheduleRecurring(group, runnable, period, timeUnit);
    }

    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        this.counter.getAndIncrement();
        return this.delegate.scheduleRecurring(group, runnable, initialDelay, period, timeUnit);
    }

    public void init() {
        this.delegate.init();
    }

    public void start() throws Throwable {
        this.delegate.start();
    }

    public void stop() throws Throwable {
        this.delegate.stop();
    }

    public void shutdown() {
        this.delegate.shutdown();
    }
}

