/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import java.util.function.IntFunction;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceCollections;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexReader;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionVersion;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class FusionIndexReaderTest {
    private IndexReader[] aliveReaders;
    private IndexReader[] readers;
    private FusionIndexReader fusionIndexReader;
    private static final int PROP_KEY = 1;
    private static final int LABEL_KEY = 11;
    @Parameterized.Parameter
    public static FusionVersion fusionVersion;

    @Parameterized.Parameters(name="{0}")
    public static FusionVersion[] versions() {
        return new FusionVersion[]{FusionVersion.v00, FusionVersion.v10, FusionVersion.v20};
    }

    @Before
    public void setup() {
        this.initiateMocks();
    }

    private void initiateMocks() {
        int[] activeSlots = fusionVersion.aliveSlots();
        this.readers = new IndexReader[5];
        Arrays.fill(this.readers, IndexReader.EMPTY);
        this.aliveReaders = new IndexReader[activeSlots.length];
        block7: for (int i = 0; i < activeSlots.length; ++i) {
            IndexReader mock;
            this.aliveReaders[i] = mock = (IndexReader)Mockito.mock(IndexReader.class);
            switch (activeSlots[i]) {
                case 0: {
                    this.readers[0] = mock;
                    continue block7;
                }
                case 1: {
                    this.readers[1] = mock;
                    continue block7;
                }
                case 2: {
                    this.readers[2] = mock;
                    continue block7;
                }
                case 3: {
                    this.readers[3] = mock;
                    continue block7;
                }
                case 4: {
                    this.readers[4] = mock;
                    continue block7;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.fusionIndexReader = new FusionIndexReader(fusionVersion.slotSelector(), new LazyInstanceSelector((Object[])this.readers, this.throwingFactory()), SchemaIndexDescriptorFactory.forLabel((int)11, (int[])new int[]{1}));
    }

    private IntFunction<IndexReader> throwingFactory() {
        return i -> {
            throw new IllegalStateException("All readers should exist already");
        };
    }

    @Test
    public void closeMustCloseBothNativeAndLucene() {
        this.fusionIndexReader.close();
        for (IndexReader reader : this.aliveReaders) {
            ((IndexReader)Mockito.verify((Object)reader, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @Test
    public void closeIteratorMustCloseAll() throws Exception {
        PrimitiveLongResourceIterator[] iterators = new PrimitiveLongResourceIterator[this.aliveReaders.length];
        for (int i = 0; i < this.aliveReaders.length; ++i) {
            PrimitiveLongResourceIterator iterator = (PrimitiveLongResourceIterator)Mockito.mock(PrimitiveLongResourceIterator.class);
            Mockito.when((Object)this.aliveReaders[i].query(new IndexQuery[]{(IndexQuery)ArgumentMatchers.any(IndexQuery.class)})).thenReturn((Object)iterator);
            iterators[i] = iterator;
        }
        this.fusionIndexReader.query(new IndexQuery[]{IndexQuery.exists((int)1)}).close();
        for (PrimitiveLongResourceIterator iterator : iterators) {
            ((PrimitiveLongResourceIterator)Mockito.verify((Object)iterator, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @Test
    public void countIndexedNodesMustSelectCorrectReader() {
        Value[][] values = FusionIndexTestHelp.valuesByGroup();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (int i = 0; i < this.readers.length; ++i) {
            Value[] valueArray = values[i];
            int n = valueArray.length;
            for (int j = 0; j < n; ++j) {
                Value value = valueArray[j];
                this.verifyCountIndexedNodesWithCorrectReader(this.orLucene(this.readers[i]), value);
            }
        }
        for (Value firstValue : allValues) {
            for (Value secondValue : allValues) {
                this.verifyCountIndexedNodesWithCorrectReader(this.readers[4], firstValue, secondValue);
            }
        }
    }

    private void verifyCountIndexedNodesWithCorrectReader(IndexReader correct, Value ... nativeValue) {
        this.fusionIndexReader.countIndexedNodes(0L, nativeValue);
        ((IndexReader)Mockito.verify((Object)correct, (VerificationMode)Mockito.times((int)1))).countIndexedNodes(0L, nativeValue);
        for (IndexReader reader : this.aliveReaders) {
            if (reader == correct) continue;
            ((IndexReader)Mockito.verify((Object)reader, (VerificationMode)Mockito.never())).countIndexedNodes(0L, nativeValue);
        }
    }

    @Test
    public void mustSelectLuceneForCompositePredicate() throws Exception {
        this.verifyQueryWithCorrectReader(this.readers[4], (IndexQuery)ArgumentMatchers.any(IndexQuery.class), (IndexQuery)ArgumentMatchers.any(IndexQuery.class));
    }

    @Test
    public void mustSelectStringForExactPredicateWithNumberValue() throws Exception {
        for (Value value : FusionIndexTestHelp.valuesSupportedByString()) {
            IndexQuery.ExactPredicate indexQuery = IndexQuery.exact((int)1, (Object)value);
            this.verifyQueryWithCorrectReader(this.expectedForStrings(), new IndexQuery[]{indexQuery});
        }
    }

    @Test
    public void mustSelectNumberForExactPredicateWithNumberValue() throws Exception {
        for (Value value : FusionIndexTestHelp.valuesSupportedByNumber()) {
            IndexQuery.ExactPredicate indexQuery = IndexQuery.exact((int)1, (Object)value);
            this.verifyQueryWithCorrectReader(this.expectedForNumbers(), new IndexQuery[]{indexQuery});
        }
    }

    @Test
    public void mustSelectSpatialForExactPredicateWithSpatialValue() throws Exception {
        Assume.assumeTrue((boolean)this.hasSpatialSupport());
        for (Value value : FusionIndexTestHelp.valuesSupportedBySpatial()) {
            IndexQuery.ExactPredicate indexQuery = IndexQuery.exact((int)1, (Object)value);
            this.verifyQueryWithCorrectReader(this.readers[2], new IndexQuery[]{indexQuery});
        }
    }

    @Test
    public void mustSelectTemporalForExactPredicateWithTemporalValue() throws Exception {
        Assume.assumeTrue((boolean)this.hasTemporalSupport());
        for (Value temporalValue : FusionIndexTestHelp.valuesSupportedByTemporal()) {
            IndexQuery.ExactPredicate indexQuery = IndexQuery.exact((int)1, (Object)temporalValue);
            this.verifyQueryWithCorrectReader(this.readers[3], new IndexQuery[]{indexQuery});
        }
    }

    @Test
    public void mustSelectLuceneForExactPredicateWithOtherValue() throws Exception {
        for (Value value : FusionIndexTestHelp.valuesNotSupportedBySpecificIndex()) {
            IndexQuery.ExactPredicate indexQuery = IndexQuery.exact((int)1, (Object)value);
            this.verifyQueryWithCorrectReader(this.readers[4], new IndexQuery[]{indexQuery});
        }
    }

    @Test
    public void mustSelectStringForRangeStringPredicate() throws Exception {
        IndexQuery.RangePredicate stringRange = IndexQuery.range((int)1, (String)"abc", (boolean)true, (String)"def", (boolean)false);
        this.verifyQueryWithCorrectReader(this.expectedForStrings(), new IndexQuery[]{stringRange});
    }

    @Test
    public void mustSelectNumberForRangeNumericPredicate() throws Exception {
        IndexQuery.RangePredicate numberRange = IndexQuery.range((int)1, (Number)0, (boolean)true, (Number)1, (boolean)false);
        this.verifyQueryWithCorrectReader(this.expectedForNumbers(), new IndexQuery[]{numberRange});
    }

    @Test
    public void mustSelectSpatialForRangeGeometricPredicate() throws Exception {
        Assume.assumeTrue((boolean)this.hasSpatialSupport());
        PointValue from = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0});
        PointValue to = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{2.0, 2.0});
        IndexQuery.RangePredicate geometryRange = IndexQuery.range((int)1, (Value)from, (boolean)true, (Value)to, (boolean)false);
        this.verifyQueryWithCorrectReader(this.readers[2], new IndexQuery[]{geometryRange});
    }

    @Test
    public void mustSelectStringForStringPrefixPredicate() throws Exception {
        IndexQuery.StringPrefixPredicate stringPrefix = IndexQuery.stringPrefix((int)1, (String)"abc");
        this.verifyQueryWithCorrectReader(this.expectedForStrings(), new IndexQuery[]{stringPrefix});
    }

    @Test
    public void mustSelectStringForStringSuffixPredicate() throws Exception {
        IndexQuery.StringSuffixPredicate stringPrefix = IndexQuery.stringSuffix((int)1, (String)"abc");
        this.verifyQueryWithCorrectReader(this.expectedForStrings(), new IndexQuery[]{stringPrefix});
    }

    @Test
    public void mustSelectStringForStringContainsPredicate() throws Exception {
        IndexQuery.StringContainsPredicate stringContains = IndexQuery.stringContains((int)1, (String)"abc");
        this.verifyQueryWithCorrectReader(this.expectedForStrings(), new IndexQuery[]{stringContains});
    }

    @Test
    public void mustCombineResultFromExistsPredicate() throws Exception {
        IndexQuery.ExistsPredicate exists = IndexQuery.exists((int)1);
        long lastId = 0L;
        for (IndexReader aliveReader : this.aliveReaders) {
            Mockito.when((Object)aliveReader.query(new IndexQuery[]{exists})).thenReturn((Object)PrimitiveLongResourceCollections.iterator(null, (long[])new long[]{lastId++, lastId++}));
        }
        PrimitiveLongResourceIterator result = this.fusionIndexReader.query(new IndexQuery[]{exists});
        PrimitiveLongSet resultSet = PrimitiveLongCollections.asSet((PrimitiveLongIterator)result);
        for (long i = 0L; i < lastId; ++i) {
            Assert.assertTrue((String)("Expected to contain " + i + ", but was " + resultSet), (boolean)resultSet.contains(i));
        }
    }

    @Test
    public void shouldInstantiatePartLazilyForSpecificValueGroupQuery() throws IndexNotApplicableKernelException {
        Value[][] values = FusionIndexTestHelp.valuesByGroup();
        for (int i = 0; i < this.readers.length; ++i) {
            if (this.readers[i] != IndexReader.EMPTY) {
                Value value = values[i][0];
                this.fusionIndexReader.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)value)});
                for (int j = 0; j < this.readers.length; ++j) {
                    if (this.readers[j] == IndexReader.EMPTY) continue;
                    if (i == j) {
                        ((IndexReader)Mockito.verify((Object)this.readers[i])).query(new IndexQuery[]{(IndexQuery)ArgumentMatchers.any(IndexQuery.class)});
                        continue;
                    }
                    Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.readers[j]});
                }
            }
            this.initiateMocks();
        }
    }

    private void verifyQueryWithCorrectReader(IndexReader expectedReader, IndexQuery ... indexQuery) throws IndexNotApplicableKernelException {
        this.fusionIndexReader.query(indexQuery);
        ((IndexReader)Mockito.verify((Object)expectedReader, (VerificationMode)Mockito.times((int)1))).query(indexQuery);
        for (IndexReader reader : this.aliveReaders) {
            if (reader == expectedReader) continue;
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{reader});
        }
    }

    private IndexReader expectedForStrings() {
        return this.orLucene(this.readers[0]);
    }

    private IndexReader expectedForNumbers() {
        return this.orLucene(this.readers[1]);
    }

    private boolean hasSpatialSupport() {
        return this.readers[2] != IndexReader.EMPTY;
    }

    private boolean hasTemporalSupport() {
        return this.readers[3] != IndexReader.EMPTY;
    }

    private IndexReader orLucene(IndexReader reader) {
        return reader != IndexReader.EMPTY ? reader : this.readers[4];
    }
}

