/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.SpatialLayout;
import org.neo4j.kernel.impl.index.schema.SpatialSchemaKey;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.test.Randoms;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class SpatialLayoutTestUtil
extends LayoutTestUtil<SpatialSchemaKey, NativeSchemaValue> {
    private static final PointValue[] ALL_EXTREME_VALUES = new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-180.0, -90.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-180.0, 90.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-1.0, -1.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{180.0, -90.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{180.0, 90.0})};
    private final CoordinateReferenceSystem crs;
    private final SpaceFillingCurve curve;

    public static PointValue randomPoint(Randoms random) {
        Random randomm = random.random();
        double x = randomm.nextDouble() * 360.0 - 180.0;
        double y = randomm.nextDouble() * 180.0 - 90.0;
        return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{x, y});
    }

    SpatialLayoutTestUtil(SchemaIndexDescriptor descriptor, SpaceFillingCurveSettings settings, CoordinateReferenceSystem crs) {
        super(descriptor);
        this.curve = settings.curve();
        this.crs = crs;
        assert (crs == CoordinateReferenceSystem.WGS84);
    }

    @Override
    Layout<SpatialSchemaKey, NativeSchemaValue> createLayout() {
        return new SpatialLayout(this.crs, this.curve);
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdates() {
        return this.someUpdatesWithDuplicateValues();
    }

    @Override
    IndexQuery rangeQuery(Value from, boolean fromInclusive, Value to, boolean toInclusive) {
        return IndexQuery.range((int)0, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive);
    }

    @Override
    int compareIndexedPropertyValue(SpatialSchemaKey key1, SpatialSchemaKey key2) {
        return Long.compare(key1.rawValueBits, key2.rawValueBits);
    }

    @Override
    Value newUniqueValue(RandomRule random, Set<Object> uniqueCompareValues, List<Value> uniqueValues) {
        PointValue pointValue;
        Long compareValue;
        while (!uniqueCompareValues.add(compareValue = this.curve.derivedValueFor((pointValue = SpatialLayoutTestUtil.randomPoint(random.randoms())).coordinate()))) {
        }
        uniqueValues.add((Value)pointValue);
        return pointValue;
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesNoDuplicateValues() {
        return this.generateAddUpdatesFor(ALL_EXTREME_VALUES);
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesWithDuplicateValues() {
        return this.generateAddUpdatesFor(ArrayUtils.addAll((Object[])ALL_EXTREME_VALUES, (Object[])ALL_EXTREME_VALUES));
    }
}

