/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.NumberSchemaKey;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

abstract class NumberLayoutTestUtil
extends LayoutTestUtil<NumberSchemaKey, NativeSchemaValue> {
    private static final Number[] ALL_EXTREME_VALUES = new Number[]{(byte)127, (byte)-128, (short)Short.MAX_VALUE, (short)Short.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Long.MAX_VALUE, Long.MIN_VALUE, Float.valueOf(Float.MAX_VALUE), Float.valueOf(-3.4028235E38f), Double.MAX_VALUE, -1.7976931348623157E308, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0, 1234567890123456788L, 1234567890123456789L};

    NumberLayoutTestUtil(SchemaIndexDescriptor schemaIndexDescriptor) {
        super(schemaIndexDescriptor);
    }

    @Override
    IndexQuery rangeQuery(Value from, boolean fromInclusive, Value to, boolean toInclusive) {
        return IndexQuery.range((int)0, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive);
    }

    @Override
    int compareIndexedPropertyValue(NumberSchemaKey key1, NumberSchemaKey key2) {
        int typeCompare = Byte.compare(key1.type, key2.type);
        if (typeCompare == 0) {
            return Long.compare(key1.rawValueBits, key2.rawValueBits);
        }
        return typeCompare;
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesNoDuplicateValues() {
        return this.generateAddUpdatesFor(ALL_EXTREME_VALUES);
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesWithDuplicateValues() {
        return this.generateAddUpdatesFor(ArrayUtils.addAll((Object[])ALL_EXTREME_VALUES, (Object[])ALL_EXTREME_VALUES));
    }

    @Override
    Value newUniqueValue(RandomRule random, Set<Object> uniqueCompareValues, List<Value> uniqueValues) {
        Number value;
        Double compareValue;
        while (!uniqueCompareValues.add(compareValue = Double.valueOf((value = random.numberPropertyValue()).doubleValue()))) {
        }
        Value storableValue = Values.of((Object)value);
        uniqueValues.add(storableValue);
        return storableValue;
    }
}

