/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class NativeSchemaIndexAccessorTest<KEY extends NativeSchemaKey<KEY>, VALUE extends NativeSchemaValue>
extends NativeSchemaIndexTestUtil<KEY, VALUE> {
    NativeSchemaIndexAccessor<KEY, VALUE> accessor;
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Before
    public void setupAccessor() throws IOException {
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
        this.accessor = this.makeAccessorWithSamplingConfig(samplingConfig);
    }

    abstract NativeSchemaIndexAccessor<KEY, VALUE> makeAccessorWithSamplingConfig(IndexSamplingConfig var1) throws IOException;

    @After
    public void closeAccessor() throws IOException {
        this.accessor.close();
    }

    @Test
    public void shouldHandleCloseWithoutCallsToProcess() throws Exception {
        NativeSchemaIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);
        updater.close();
    }

    @Test
    public void processMustThrowAfterClose() throws Exception {
        NativeSchemaIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);
        updater.close();
        this.expected.expect(IllegalStateException.class);
        updater.process(this.simpleUpdate());
    }

    @Test
    public void shouldIndexAdd() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        try (NativeSchemaIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            this.processAll((IndexUpdater)updater, updates);
        }
        this.forceAndCloseAccessor();
        this.verifyUpdates(updates);
    }

    @Test
    public void shouldIndexChange() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        Iterator generator = Iterators.filter(NativeSchemaIndexAccessorTest.skipExisting(updates), this.layoutUtil.randomUpdateGenerator(this.random));
        for (int i = 0; i < updates.length; ++i) {
            IndexEntryUpdate<SchemaIndexDescriptor> update = updates[i];
            Value newValue = ((IndexEntryUpdate)generator.next()).values()[0];
            updates[i] = IndexEntryUpdate.change((long)update.getEntityId(), (SchemaDescriptorSupplier)this.schemaIndexDescriptor, (Value)update.values()[0], (Value)newValue);
        }
        this.processAll(updates);
        this.forceAndCloseAccessor();
        this.verifyUpdates(updates);
    }

    @Test
    public void shouldIndexRemove() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        for (int i = 0; i < updates.length; ++i) {
            IndexEntryUpdate<SchemaIndexDescriptor> update = updates[i];
            IndexEntryUpdate remove = IndexEntryUpdate.remove((long)update.getEntityId(), (SchemaDescriptorSupplier)this.schemaIndexDescriptor, (Value[])update.values());
            this.processAll(remove);
            this.forceAndCloseAccessor();
            this.verifyUpdates(Arrays.copyOfRange(updates, i + 1, updates.length));
            this.setupAccessor();
        }
    }

    @Test
    public void shouldHandleRandomUpdates() throws Exception {
        HashSet<IndexEntryUpdate<SchemaIndexDescriptor>> expectedData = new HashSet<IndexEntryUpdate<SchemaIndexDescriptor>>();
        Iterator<IndexEntryUpdate<SchemaIndexDescriptor>> newDataGenerator = this.layoutUtil.randomUpdateGenerator(this.random);
        int rounds = 50;
        for (int round = 0; round < rounds; ++round) {
            IndexEntryUpdate<SchemaIndexDescriptor>[] batch = this.generateRandomUpdates(expectedData, newDataGenerator, this.random.nextInt(5, 20), (float)round / (float)rounds * 2.0f);
            this.processAll(batch);
            this.applyUpdatesToExpectedData(expectedData, batch);
            this.forceAndCloseAccessor();
            this.verifyUpdates(expectedData.toArray(new IndexEntryUpdate[expectedData.size()]));
            this.setupAccessor();
        }
    }

    @Test
    public void shouldReturnZeroCountForEmptyIndex() {
        try (IndexReader reader = this.accessor.newReader();){
            IndexEntryUpdate<SchemaIndexDescriptor> update = this.layoutUtil.randomUpdateGenerator(this.random).next();
            long count = reader.countIndexedNodes(123L, new Value[]{update.values()[0]});
            Assert.assertEquals((long)0L, (long)count);
        }
    }

    @Test
    public void shouldReturnCountOneForExistingData() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        try (IndexReader reader = this.accessor.newReader();){
            for (IndexEntryUpdate<SchemaIndexDescriptor> update : updates) {
                long count = reader.countIndexedNodes(update.getEntityId(), update.values());
                Assert.assertEquals((long)1L, (long)count);
            }
            Iterator generator = Iterators.filter(NativeSchemaIndexAccessorTest.skipExisting(updates), this.layoutUtil.randomUpdateGenerator(this.random));
            long count = reader.countIndexedNodes(123L, new Value[]{((IndexEntryUpdate)generator.next()).values()[0]});
            Assert.assertEquals((long)0L, (long)count);
        }
    }

    @Test
    public void shouldReturnCountZeroForMismatchingData() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        for (IndexEntryUpdate<SchemaIndexDescriptor> update : updates) {
            long countWithMismatchingData = reader.countIndexedNodes(update.getEntityId() + 1L, update.values());
            long countWithNonExistentEntityId = reader.countIndexedNodes(1000000000L, update.values());
            long countWithNonExistentValue = reader.countIndexedNodes(update.getEntityId(), new Value[]{this.generateUniqueValue(updates)});
            Assert.assertEquals((long)0L, (long)countWithMismatchingData);
            Assert.assertEquals((long)0L, (long)countWithNonExistentEntityId);
            Assert.assertEquals((long)0L, (long)countWithNonExistentValue);
        }
    }

    @Test
    public void shouldReturnAllEntriesForExistsPredicate() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator result = this.query(reader, (IndexQuery)IndexQuery.exists((int)0));
        this.assertEntityIdHits(this.extractEntityIds(updates, Predicates.alwaysTrue()), result);
    }

    @Test
    public void shouldReturnNoEntriesForExistsPredicateForEmptyIndex() throws Exception {
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator result = this.query(reader, (IndexQuery)IndexQuery.exists((int)0));
        long[] actual = PrimitiveLongCollections.asArray((PrimitiveLongIterator)result);
        Assert.assertEquals((long)0L, (long)actual.length);
    }

    @Test
    public void shouldReturnMatchingEntriesForExactPredicate() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        for (IndexEntryUpdate<SchemaIndexDescriptor> update : updates) {
            Value value = update.values()[0];
            PrimitiveLongIterator result = this.query(reader, (IndexQuery)IndexQuery.exact((int)0, (Object)value));
            this.assertEntityIdHits(this.extractEntityIds(updates, Predicates.in((Object[])new Value[]{value})), result);
        }
    }

    @Test
    public void shouldReturnNoEntriesForMismatchingExactPredicate() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        IndexReader reader = this.accessor.newReader();
        Value value = this.generateUniqueValue(updates);
        PrimitiveLongIterator result = this.query(reader, (IndexQuery)IndexQuery.exact((int)0, (Object)value));
        this.assertEntityIdHits(PrimitiveLongCollections.EMPTY_LONG_ARRAY, result);
    }

    @Test
    public void shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndExclusiveEnd() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdatesNoDuplicateValues();
        this.processAll(updates);
        this.layoutUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator result = this.query(reader, this.layoutUtil.rangeQuery(this.valueOf(updates[0]), true, this.valueOf(updates[updates.length - 1]), false));
        this.assertEntityIdHits(this.extractEntityIds(Arrays.copyOf(updates, updates.length - 1), Predicates.alwaysTrue()), result);
    }

    @Test
    public void shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndInclusiveEnd() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdatesNoDuplicateValues();
        this.processAll(updates);
        this.layoutUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator result = this.query(reader, this.layoutUtil.rangeQuery(this.valueOf(updates[0]), true, this.valueOf(updates[updates.length - 1]), true));
        this.assertEntityIdHits(this.extractEntityIds(updates, Predicates.alwaysTrue()), result);
    }

    @Test
    public void shouldReturnMatchingEntriesForRangePredicateWithExclusiveStartAndExclusiveEnd() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdatesNoDuplicateValues();
        this.processAll(updates);
        this.layoutUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator result = this.query(reader, this.layoutUtil.rangeQuery(this.valueOf(updates[0]), false, this.valueOf(updates[updates.length - 1]), false));
        this.assertEntityIdHits(this.extractEntityIds(Arrays.copyOfRange(updates, 1, updates.length - 1), Predicates.alwaysTrue()), result);
    }

    @Test
    public void shouldReturnMatchingEntriesForRangePredicateWithExclusiveStartAndInclusiveEnd() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdatesNoDuplicateValues();
        this.processAll(updates);
        this.layoutUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator result = this.query(reader, this.layoutUtil.rangeQuery(this.valueOf(updates[0]), false, this.valueOf(updates[updates.length - 1]), true));
        this.assertEntityIdHits(this.extractEntityIds(Arrays.copyOfRange(updates, 1, updates.length), Predicates.alwaysTrue()), result);
    }

    @Test
    public void shouldReturnNoEntriesForRangePredicateOutsideAnyMatch() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.layoutUtil.sort(updates);
        this.processAll(updates[0], updates[1], updates[updates.length - 1], updates[updates.length - 2]);
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator result = this.query(reader, this.layoutUtil.rangeQuery(this.valueOf(updates[2]), true, this.valueOf(updates[updates.length - 3]), true));
        this.assertEntityIdHits(PrimitiveLongCollections.EMPTY_LONG_ARRAY, result);
    }

    @Test(timeout=10000L)
    public void mustHandleNestedQueries() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        this.layoutUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        IndexQuery outerQuery = this.layoutUtil.rangeQuery(this.valueOf(updates[2]), true, this.valueOf(updates[3]), true);
        IndexQuery innerQuery = this.layoutUtil.rangeQuery(this.valueOf(updates[0]), true, this.valueOf(updates[1]), true);
        long[] expectedOuter = new long[]{this.entityIdOf(updates[2]), this.entityIdOf(updates[3])};
        long[] expectedInner = new long[]{this.entityIdOf(updates[0]), this.entityIdOf(updates[1])};
        PrimitiveLongIterator outerIter = this.query(reader, outerQuery);
        ArrayList<Long> outerResult = new ArrayList<Long>();
        while (outerIter.hasNext()) {
            outerResult.add(outerIter.next());
            PrimitiveLongIterator innerIter = this.query(reader, innerQuery);
            this.assertEntityIdHits(expectedInner, innerIter);
        }
        this.assertEntityIdHits(expectedOuter, outerResult);
    }

    @Test
    public void mustHandleMultipleNestedQueries() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        this.layoutUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        IndexQuery query1 = this.layoutUtil.rangeQuery(this.valueOf(updates[4]), true, this.valueOf(updates[5]), true);
        IndexQuery query2 = this.layoutUtil.rangeQuery(this.valueOf(updates[2]), true, this.valueOf(updates[3]), true);
        IndexQuery query3 = this.layoutUtil.rangeQuery(this.valueOf(updates[0]), true, this.valueOf(updates[1]), true);
        long[] expected1 = new long[]{this.entityIdOf(updates[4]), this.entityIdOf(updates[5])};
        long[] expected2 = new long[]{this.entityIdOf(updates[2]), this.entityIdOf(updates[3])};
        long[] expected3 = new long[]{this.entityIdOf(updates[0]), this.entityIdOf(updates[1])};
        ArrayList<Long> result1 = new ArrayList<Long>();
        PrimitiveLongIterator iter1 = this.query(reader, query1);
        while (iter1.hasNext()) {
            result1.add(iter1.next());
            ArrayList<Long> result2 = new ArrayList<Long>();
            PrimitiveLongIterator iter2 = this.query(reader, query2);
            while (iter2.hasNext()) {
                result2.add(iter2.next());
                ArrayList<Long> result3 = new ArrayList<Long>();
                PrimitiveLongIterator iter3 = this.query(reader, query3);
                while (iter3.hasNext()) {
                    result3.add(iter3.next());
                }
                this.assertEntityIdHits(expected3, result3);
            }
            this.assertEntityIdHits(expected2, result2);
        }
        this.assertEntityIdHits(expected1, result1);
    }

    private long entityIdOf(IndexEntryUpdate<SchemaIndexDescriptor> update) {
        return update.getEntityId();
    }

    @Test
    public void shouldHandleMultipleConsecutiveUpdaters() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates;
        for (IndexEntryUpdate<SchemaIndexDescriptor> update : updates = this.layoutUtil.someUpdates()) {
            try (NativeSchemaIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
                updater.process(update);
            }
        }
        this.forceAndCloseAccessor();
        this.verifyUpdates(updates);
    }

    @Test
    public void requestForSecondUpdaterMustThrow() throws Exception {
        try (NativeSchemaIndexUpdater ignored = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            this.expected.expect(IllegalStateException.class);
            this.accessor.newUpdater(IndexUpdateMode.ONLINE);
        }
    }

    @Test
    public void dropShouldDeleteAndCloseIndex() throws Exception {
        this.assertFilePresent();
        this.accessor.drop();
        this.assertFileNotPresent();
    }

    @Test
    public void forceShouldCheckpointTree() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] data = this.layoutUtil.someUpdates();
        this.processAll(data);
        this.accessor.force(IOLimiter.unlimited());
        this.accessor.close();
        this.verifyUpdates(data);
    }

    @Test
    public void closeShouldCloseTreeWithoutCheckpoint() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] data = this.layoutUtil.someUpdates();
        this.processAll(data);
        this.accessor.close();
        this.verifyUpdates(new IndexEntryUpdate[0]);
    }

    @Test
    public void snapshotFilesShouldReturnIndexFile() {
        ResourceIterator files = this.accessor.snapshotFiles();
        Assert.assertTrue((boolean)files.hasNext());
        Assert.assertEquals((Object)this.getIndexFile(), (Object)files.next());
        Assert.assertFalse((boolean)files.hasNext());
    }

    @Test
    public void shouldSampleIndex() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        try (IndexReader reader = this.accessor.newReader();){
            IndexSampler sampler = reader.createSampler();
            IndexSample sample = sampler.sampleIndex();
            Assert.assertEquals((long)updates.length, (long)sample.indexSize());
            Assert.assertEquals((long)updates.length, (long)sample.sampleSize());
            Assert.assertEquals((long)LayoutTestUtil.countUniqueValues(updates), (long)sample.uniqueValues());
        }
    }

    @Test
    public void readingAfterDropShouldThrow() throws Exception {
        this.accessor.drop();
        this.expected.expect(IllegalStateException.class);
        this.accessor.newReader();
    }

    @Test
    public void writingAfterDropShouldThrow() throws Exception {
        this.accessor.drop();
        this.expected.expect(IllegalStateException.class);
        this.accessor.newUpdater(IndexUpdateMode.ONLINE);
    }

    @Test
    public void readingAfterCloseShouldThrow() throws Exception {
        this.accessor.close();
        this.expected.expect(IllegalStateException.class);
        this.accessor.newReader();
    }

    @Test
    public void writingAfterCloseShouldThrow() throws Exception {
        this.accessor.close();
        this.expected.expect(IllegalStateException.class);
        this.accessor.newUpdater(IndexUpdateMode.ONLINE);
    }

    @Test
    public void shouldSeeAllEntriesInAllEntriesReader() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.processAll(updates);
        Set ids = Iterables.asUniqueSet((Iterable)this.accessor.newAllEntriesReader());
        Set expectedIds = Stream.of(updates).map(IndexEntryUpdate::getEntityId).collect(Collectors.toCollection(HashSet::new));
        Assert.assertEquals((Object)expectedIds, (Object)ids);
    }

    @Test
    public void shouldSeeNoEntriesInAllEntriesReaderOnEmptyIndex() {
        Set ids = Iterables.asUniqueSet((Iterable)this.accessor.newAllEntriesReader());
        Set expectedIds = Collections.emptySet();
        Assert.assertEquals(expectedIds, (Object)ids);
    }

    @Test
    public void shouldNotSeeFilteredEntries() throws Exception {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdatesNoDuplicateValues();
        this.processAll(updates);
        this.layoutUtil.sort(updates);
        IndexReader reader = this.accessor.newReader();
        NodeValueIterator iter = new NodeValueIterator();
        IndexQuery.ExactPredicate filter = IndexQuery.exact((int)0, (Object)this.valueOf(updates[1]));
        IndexQuery rangeQuery = this.layoutUtil.rangeQuery(this.valueOf(updates[0]), true, this.valueOf(updates[2]), true);
        IndexProgressor.NodeValueClient filterClient = this.filterClient(iter, filter);
        reader.query(filterClient, IndexOrder.NONE, new IndexQuery[]{rangeQuery});
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((long)this.entityIdOf(updates[1]), (long)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    private Value generateUniqueValue(IndexEntryUpdate<SchemaIndexDescriptor>[] updates) {
        return ((IndexEntryUpdate)Iterators.filter(NativeSchemaIndexAccessorTest.skipExisting(updates), this.layoutUtil.randomUpdateGenerator(this.random)).next()).values()[0];
    }

    private static Predicate<IndexEntryUpdate<SchemaIndexDescriptor>> skipExisting(IndexEntryUpdate<SchemaIndexDescriptor>[] existing) {
        return update -> {
            for (IndexEntryUpdate e : existing) {
                if (!Arrays.equals(e.values(), update.values())) continue;
                return false;
            }
            return true;
        };
    }

    private Value valueOf(IndexEntryUpdate<SchemaIndexDescriptor> update) {
        return update.values()[0];
    }

    private IndexProgressor.NodeValueClient filterClient(final NodeValueIterator iter, final IndexQuery.ExactPredicate filter) {
        return new IndexProgressor.NodeValueClient(){

            public void initialize(SchemaIndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query) {
                iter.initialize(descriptor, progressor, query);
            }

            public boolean acceptNode(long reference, Value ... values) {
                if (values.length > 1) {
                    return false;
                }
                return filter.acceptsValue(values[0]) && iter.acceptNode(reference, values);
            }

            public boolean needsValues() {
                return true;
            }
        };
    }

    private PrimitiveLongIterator query(IndexReader reader, IndexQuery query) throws IndexNotApplicableKernelException {
        NodeValueIterator client = new NodeValueIterator();
        reader.query((IndexProgressor.NodeValueClient)client, IndexOrder.NONE, new IndexQuery[]{query});
        return client;
    }

    private void assertEntityIdHits(long[] expected, PrimitiveLongIterator result) {
        long[] actual = PrimitiveLongCollections.asArray((PrimitiveLongIterator)result);
        this.assertSameContent(expected, actual);
    }

    private void assertEntityIdHits(long[] expected, Collection<Long> result) {
        long[] actual = new long[result.size()];
        int index = 0;
        for (Long aLong : result) {
            actual[index++] = aLong;
        }
        this.assertSameContent(expected, actual);
    }

    private void assertSameContent(long[] expected, long[] actual) {
        Arrays.sort(actual);
        Arrays.sort(expected);
        Assert.assertArrayEquals((String)String.format("Expected arrays to be equal but wasn't.%nexpected:%s%n  actual:%s%n", Arrays.toString(expected), Arrays.toString(actual)), (long[])expected, (long[])actual);
    }

    private long[] extractEntityIds(IndexEntryUpdate<?>[] updates, Predicate<Value> valueFilter) {
        long[] entityIds = new long[updates.length];
        int cursor = 0;
        for (IndexEntryUpdate<?> update : updates) {
            if (!valueFilter.test(update.values()[0])) continue;
            entityIds[cursor++] = update.getEntityId();
        }
        return Arrays.copyOf(entityIds, cursor);
    }

    private void applyUpdatesToExpectedData(Set<IndexEntryUpdate<SchemaIndexDescriptor>> expectedData, IndexEntryUpdate<SchemaIndexDescriptor>[] batch) {
        for (IndexEntryUpdate<SchemaIndexDescriptor> update : batch) {
            IndexEntryUpdate<SchemaIndexDescriptor> addition = null;
            IndexEntryUpdate<SchemaIndexDescriptor> removal = null;
            switch (update.updateMode()) {
                case ADDED: {
                    addition = this.layoutUtil.add(update.getEntityId(), update.values()[0]);
                    break;
                }
                case CHANGED: {
                    addition = this.layoutUtil.add(update.getEntityId(), update.values()[0]);
                    removal = this.layoutUtil.add(update.getEntityId(), update.beforeValues()[0]);
                    break;
                }
                case REMOVED: {
                    removal = this.layoutUtil.add(update.getEntityId(), update.values()[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(update.updateMode().name());
                }
            }
            if (removal != null) {
                expectedData.remove(removal);
            }
            if (addition == null) continue;
            expectedData.add(addition);
        }
    }

    private IndexEntryUpdate<SchemaIndexDescriptor>[] generateRandomUpdates(Set<IndexEntryUpdate<SchemaIndexDescriptor>> expectedData, Iterator<IndexEntryUpdate<SchemaIndexDescriptor>> newDataGenerator, int count, float removeFactor) {
        IndexEntryUpdate[] updates = new IndexEntryUpdate[count];
        float addChangeRatio = 0.5f;
        for (int i = 0; i < count; ++i) {
            float factor = this.random.nextFloat();
            if (!expectedData.isEmpty() && factor < removeFactor) {
                IndexEntryUpdate<SchemaIndexDescriptor> toRemove = this.selectRandomItem(expectedData);
                updates[i] = IndexEntryUpdate.remove((long)toRemove.getEntityId(), (SchemaDescriptorSupplier)this.schemaIndexDescriptor, (Value[])toRemove.values());
                continue;
            }
            if (!expectedData.isEmpty() && factor < (1.0f - removeFactor) * addChangeRatio) {
                IndexEntryUpdate<SchemaIndexDescriptor> toChange = this.selectRandomItem(expectedData);
                IndexEntryUpdate<SchemaIndexDescriptor> updateContainingValue = newDataGenerator.next();
                updates[i] = IndexEntryUpdate.change((long)toChange.getEntityId(), (SchemaDescriptorSupplier)this.schemaIndexDescriptor, (Value[])toChange.values(), (Value[])updateContainingValue.values());
                continue;
            }
            updates[i] = newDataGenerator.next();
        }
        return updates;
    }

    private IndexEntryUpdate<SchemaIndexDescriptor> selectRandomItem(Set<IndexEntryUpdate<SchemaIndexDescriptor>> expectedData) {
        return expectedData.toArray(new IndexEntryUpdate[expectedData.size()])[this.random.nextInt(expectedData.size())];
    }

    @SafeVarargs
    final void processAll(IndexEntryUpdate<SchemaIndexDescriptor> ... updates) throws IOException, IndexEntryConflictException {
        try (NativeSchemaIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (IndexEntryUpdate<SchemaIndexDescriptor> update : updates) {
                updater.process(update);
            }
        }
    }

    private void forceAndCloseAccessor() throws IOException {
        this.accessor.force(IOLimiter.unlimited());
        this.closeAccessor();
    }

    private void processAll(IndexUpdater updater, IndexEntryUpdate<SchemaIndexDescriptor>[] updates) throws IOException, IndexEntryConflictException {
        for (IndexEntryUpdate<SchemaIndexDescriptor> update : updates) {
            updater.process(update);
        }
    }

    private IndexEntryUpdate<SchemaIndexDescriptor> simpleUpdate() {
        return IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)this.schemaIndexDescriptor, (Value[])new Value[]{Values.of((Object)0)});
    }
}

