/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeLayout;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.test.Randoms;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class LocalDateTimeLayoutTestUtil
extends LayoutTestUtil<LocalDateTimeSchemaKey, NativeSchemaValue> {
    private static final LocalDateTime[] ALL_EXTREME_VALUES = new LocalDateTime[]{LocalDateTime.of(-999999999, 1, 1, 0, 0, 0, 0), LocalDateTime.of(999999999, 12, 31, 23, 59, 59, 999999999), LocalDateTime.of(0, 1, 1, 0, 0, 0, 0), LocalDateTime.of(0, 1, 1, 0, 0, 0, 1), LocalDateTime.of(0, 1, 1, 0, 0, 0, 2), LocalDateTime.of(-1, 12, 31, 23, 59, 59, 999999999)};

    public static LocalDateTimeValue randomLocalDateTime(Randoms random) {
        return LocalDateTimeValue.localDateTime((LocalDateTime)random.randomLocalDateTime());
    }

    LocalDateTimeLayoutTestUtil(SchemaIndexDescriptor schemaIndexDescriptor) {
        super(schemaIndexDescriptor);
    }

    @Override
    Layout<LocalDateTimeSchemaKey, NativeSchemaValue> createLayout() {
        return new LocalDateTimeLayout();
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdates() {
        return this.someUpdatesWithDuplicateValues();
    }

    @Override
    IndexQuery rangeQuery(Value from, boolean fromInclusive, Value to, boolean toInclusive) {
        return IndexQuery.range((int)0, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive);
    }

    @Override
    int compareIndexedPropertyValue(LocalDateTimeSchemaKey key1, LocalDateTimeSchemaKey key2) {
        return Values.COMPARATOR.compare(key1.asValue(), key2.asValue());
    }

    @Override
    Value newUniqueValue(RandomRule random, Set<Object> uniqueCompareValues, List<Value> uniqueValues) {
        LocalDateTimeValue candidate;
        while (!uniqueCompareValues.add(candidate = LocalDateTimeLayoutTestUtil.randomLocalDateTime(random.randoms()))) {
        }
        uniqueValues.add((Value)candidate);
        return candidate;
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesNoDuplicateValues() {
        return this.generateAddUpdatesFor(ALL_EXTREME_VALUES);
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesWithDuplicateValues() {
        return this.generateAddUpdatesFor(ArrayUtils.addAll((Object[])ALL_EXTREME_VALUES, (Object[])ALL_EXTREME_VALUES));
    }
}

