/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.IntFunction;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.cursor.RawCursor;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.api.labelscan.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.labelscan.NodeLabelRange;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;
import org.neo4j.kernel.impl.index.labelscan.MutableHit;
import org.neo4j.kernel.impl.index.labelscan.NativeAllEntriesLabelScanReader;
import org.neo4j.test.rule.RandomRule;

public class NativeAllEntriesLabelScanReaderTest {
    @Rule
    public final RandomRule random = new RandomRule();
    private static final RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> EMPTY_CURSOR = new RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>(){

        public Hit<LabelScanKey, LabelScanValue> get() {
            throw new IllegalStateException();
        }

        public boolean next() {
            return false;
        }

        public void close() {
        }
    };

    @Test
    public void shouldSeeNonOverlappingRanges() throws Exception {
        int rangeSize = 4;
        this.shouldIterateCorrectlyOver(NativeAllEntriesLabelScanReaderTest.labels(0, rangeSize, 0L, 1L, 2L, 3L), NativeAllEntriesLabelScanReaderTest.labels(1, rangeSize, 4L, 6L), NativeAllEntriesLabelScanReaderTest.labels(2, rangeSize, 12L), NativeAllEntriesLabelScanReaderTest.labels(3, rangeSize, 17L, 18L));
    }

    @Test
    public void shouldSeeOverlappingRanges() throws Exception {
        int rangeSize = 4;
        this.shouldIterateCorrectlyOver(NativeAllEntriesLabelScanReaderTest.labels(0, rangeSize, 0L, 1L, 3L, 55L), NativeAllEntriesLabelScanReaderTest.labels(3, rangeSize, 1L, 2L, 5L, 6L, 43L), NativeAllEntriesLabelScanReaderTest.labels(5, rangeSize, 8L, 9L, 15L, 42L), NativeAllEntriesLabelScanReaderTest.labels(6, rangeSize, 4L, 8L, 12L));
    }

    @Test
    public void shouldSeeRangesFromRandomData() throws Exception {
        List<Labels> labels = this.randomData();
        this.shouldIterateCorrectlyOver(labels.toArray(new Labels[labels.size()]));
    }

    private void shouldIterateCorrectlyOver(Labels ... data) throws Exception {
        try (NativeAllEntriesLabelScanReader reader = new NativeAllEntriesLabelScanReader(NativeAllEntriesLabelScanReaderTest.store(data), NativeAllEntriesLabelScanReaderTest.highestLabelId(data));){
            NativeAllEntriesLabelScanReaderTest.assertRanges((AllEntriesLabelScanReader)reader, data);
        }
    }

    private List<Labels> randomData() {
        ArrayList<Labels> labels = new ArrayList<Labels>();
        int labelCount = this.random.intBetween(30, 100);
        int labelId = 0;
        for (int i = 0; i < labelCount; ++i) {
            labelId += this.random.intBetween(1, 20);
            int nodeCount = this.random.intBetween(20, 100);
            long[] nodeIds = new long[nodeCount];
            long nodeId = 0L;
            for (int j = 0; j < nodeCount; ++j) {
                nodeIds[j] = nodeId += (long)this.random.intBetween(1, 100);
            }
            labels.add(NativeAllEntriesLabelScanReaderTest.labels(labelId, nodeIds));
        }
        return labels;
    }

    private static int highestLabelId(Labels[] data) {
        int highest = 0;
        for (Labels labels : data) {
            highest = Integer.max(highest, labels.labelId);
        }
        return highest;
    }

    private static void assertRanges(AllEntriesLabelScanReader reader, Labels[] data) {
        Iterator iterator = reader.iterator();
        long highestRangeId = NativeAllEntriesLabelScanReaderTest.highestRangeId(data);
        for (long rangeId = 0L; rangeId <= highestRangeId; ++rangeId) {
            SortedMap<Long, List<Long>> expected = NativeAllEntriesLabelScanReaderTest.rangeOf(data, rangeId);
            if (expected == null) continue;
            Assert.assertTrue((String)("Was expecting range " + expected), (boolean)iterator.hasNext());
            NodeLabelRange range = (NodeLabelRange)iterator.next();
            Assert.assertEquals((long)rangeId, (long)range.id());
            for (Map.Entry<Long, List<Long>> expectedEntry : expected.entrySet()) {
                long[] labels = range.labels(expectedEntry.getKey().longValue());
                Assert.assertArrayEquals((long[])PrimitiveLongCollections.asArray(expectedEntry.getValue().iterator()), (long[])labels);
            }
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private static SortedMap<Long, List<Long>> rangeOf(Labels[] data, long rangeId) {
        TreeMap<Long, List<Long>> result = new TreeMap<Long, List<Long>>();
        for (Labels label : data) {
            for (Pair entry : label.entries) {
                if (((LabelScanKey)entry.first()).idRange != rangeId) continue;
                long baseNodeId = ((LabelScanKey)entry.first()).idRange * 64L;
                for (long bits = ((LabelScanValue)entry.other()).bits; bits != 0L; bits &= bits - 1L) {
                    long nodeId = baseNodeId + (long)Long.numberOfTrailingZeros(bits);
                    result.computeIfAbsent(nodeId, id -> new ArrayList()).add(Long.valueOf(label.labelId));
                }
            }
        }
        return result.isEmpty() ? null : result;
    }

    private static long highestRangeId(Labels[] data) {
        long highest = 0L;
        for (Labels labels : data) {
            Pair highestEntry = (Pair)labels.entries.get(labels.entries.size() - 1);
            highest = Long.max(highest, ((LabelScanKey)highestEntry.first()).idRange);
        }
        return highest;
    }

    private static IntFunction<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> store(Labels ... labels) {
        PrimitiveIntObjectMap labelsMap = Primitive.intObjectMap((int)labels.length);
        for (Labels item : labels) {
            labelsMap.put(item.labelId, (Object)item);
        }
        return labelId -> {
            Labels item = (Labels)labelsMap.get(labelId);
            return item != null ? item.cursor() : EMPTY_CURSOR;
        };
    }

    private static Labels labels(int labelId, long ... nodeIds) {
        ArrayList<Pair<LabelScanKey, LabelScanValue>> entries = new ArrayList<Pair<LabelScanKey, LabelScanValue>>();
        long currentRange = 0L;
        LabelScanValue value = new LabelScanValue();
        for (long nodeId : nodeIds) {
            long range = nodeId / 64L;
            if (range != currentRange && value.bits != 0L) {
                entries.add((Pair<LabelScanKey, LabelScanValue>)Pair.of((Object)new LabelScanKey().set(labelId, currentRange), (Object)value));
                value = new LabelScanValue();
            }
            value.set(Math.toIntExact(nodeId % 64L));
            currentRange = range;
        }
        if (value.bits != 0L) {
            entries.add((Pair<LabelScanKey, LabelScanValue>)Pair.of((Object)new LabelScanKey().set(labelId, currentRange), (Object)value));
        }
        return new Labels(labelId, entries);
    }

    private static class Labels {
        private final int labelId;
        private final List<Pair<LabelScanKey, LabelScanValue>> entries;

        Labels(int labelId, List<Pair<LabelScanKey, LabelScanValue>> entries) {
            this.labelId = labelId;
            this.entries = entries;
        }

        RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor() {
            return new RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>(){
                int cursor = -1;

                public Hit<LabelScanKey, LabelScanValue> get() {
                    assert (this.cursor >= 0);
                    Pair entry = (Pair)entries.get(this.cursor);
                    return new MutableHit<Object, Object>(entry.first(), entry.other());
                }

                public boolean next() {
                    if (this.cursor + 1 >= entries.size()) {
                        return false;
                    }
                    ++this.cursor;
                    return true;
                }

                public void close() {
                }
            };
        }
    }
}

