/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.CollectingIndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexCRUDIT {
    private GraphDatabaseAPI db;
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final IndexProvider mockedIndexProvider = (IndexProvider)Mockito.mock(IndexProvider.class);
    private final KernelExtensionFactory<?> mockedIndexProviderFactory = SchemaIndexTestHelper.singleInstanceIndexProviderFactory("none", this.mockedIndexProvider);
    private ThreadToStatementContextBridge ctxSupplier;
    private final Label myLabel = Label.label((String)"MYLABEL");

    @Test
    public void addingANodeWithPropertyShouldGetIndexed() throws Exception {
        String indexProperty = "indexProperty";
        GatheringIndexWriter writer = this.newWriter();
        Neo4jMatchers.createIndex((GraphDatabaseService)this.db, this.myLabel, indexProperty);
        int value1 = 12;
        String otherProperty = "otherProperty";
        int otherValue = 17;
        Node node = this.createNode(MapUtil.map((Object[])new Object[]{indexProperty, value1, otherProperty, otherValue}), this.myLabel);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = this.ctxSupplier.getKernelTransactionBoundToThisThread(true);
            TokenRead tokenRead = ktx.tokenRead();
            int propertyKey1 = tokenRead.propertyKey(indexProperty);
            int label = tokenRead.nodeLabel(this.myLabel.name());
            LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)label, (int[])new int[]{propertyKey1});
            Assert.assertThat((Object)writer.updatesCommitted, (Matcher)CoreMatchers.equalTo((Object)Iterators.asSet((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)node.getId(), (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)value1)})})));
            tx.success();
        }
    }

    @Test
    public void addingALabelToPreExistingNodeShouldGetIndexed() throws Exception {
        String indexProperty = "indexProperty";
        GatheringIndexWriter writer = this.newWriter();
        Neo4jMatchers.createIndex((GraphDatabaseService)this.db, this.myLabel, indexProperty);
        String otherProperty = "otherProperty";
        int value = 12;
        int otherValue = 17;
        Node node = this.createNode(MapUtil.map((Object[])new Object[]{indexProperty, value, otherProperty, otherValue}), new Label[0]);
        Assert.assertThat((Object)writer.updatesCommitted.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        try (Transaction tx = this.db.beginTx();){
            node.addLabel(this.myLabel);
            tx.success();
        }
        tx = this.db.beginTx();
        var8_8 = null;
        try {
            KernelTransaction ktx = this.ctxSupplier.getKernelTransactionBoundToThisThread(true);
            TokenRead tokenRead = ktx.tokenRead();
            int propertyKey1 = tokenRead.propertyKey(indexProperty);
            int label = tokenRead.nodeLabel(this.myLabel.name());
            LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)label, (int[])new int[]{propertyKey1});
            Assert.assertThat((Object)writer.updatesCommitted, (Matcher)CoreMatchers.equalTo((Object)Iterators.asSet((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)node.getId(), (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)value)})})));
            tx.success();
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private Node createNode(Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode(labels);
            for (Map.Entry<String, Object> prop : properties.entrySet()) {
                node.setProperty(prop.getKey(), prop.getValue());
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    @Before
    public void before() {
        Mockito.when((Object)this.mockedIndexProvider.getProviderDescriptor()).thenReturn((Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)this.mockedIndexProvider.storeMigrationParticipant((FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), (PageCache)ArgumentMatchers.any(PageCache.class))).thenReturn((Object)StoreMigrationParticipant.NOT_PARTICIPATING);
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        factory.setFileSystem(this.fs.get());
        factory.setKernelExtensions(Collections.singletonList(this.mockedIndexProviderFactory));
        this.db = (GraphDatabaseAPI)factory.newImpermanentDatabase();
        this.ctxSupplier = (ThreadToStatementContextBridge)this.db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }

    private GatheringIndexWriter newWriter() throws IOException {
        GatheringIndexWriter writer = new GatheringIndexWriter();
        Mockito.when((Object)this.mockedIndexProvider.getPopulator(ArgumentMatchers.anyLong(), (SchemaIndexDescriptor)ArgumentMatchers.any(SchemaIndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class))).thenReturn((Object)writer);
        Mockito.when((Object)this.mockedIndexProvider.getOnlineAccessor(ArgumentMatchers.anyLong(), (SchemaIndexDescriptor)ArgumentMatchers.any(SchemaIndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class))).thenReturn((Object)writer);
        Mockito.when((Object)this.mockedIndexProvider.compareTo((IndexProvider)ArgumentMatchers.any(IndexProvider.class))).thenReturn((Object)1);
        return writer;
    }

    @After
    public void after() {
        this.db.shutdown();
    }

    private class GatheringIndexWriter
    extends IndexAccessor.Adapter
    implements IndexPopulator {
        private final Set<IndexEntryUpdate<?>> updatesCommitted = new HashSet();
        private final Map<Object, Set<Long>> indexSamples = new HashMap<Object, Set<Long>>();

        private GatheringIndexWriter() {
        }

        public void create() {
        }

        public void add(Collection<? extends IndexEntryUpdate<?>> updates) {
            this.updatesCommitted.addAll(updates);
        }

        public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) {
        }

        public IndexUpdater newPopulatingUpdater(PropertyAccessor propertyAccessor) {
            return this.newUpdater(IndexUpdateMode.ONLINE);
        }

        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return new CollectingIndexUpdater(){

                public void close() {
                    GatheringIndexWriter.this.updatesCommitted.addAll(this.updates);
                }
            };
        }

        public void close(boolean populationCompletedSuccessfully) {
        }

        public void markAsFailed(String failure) {
        }

        public void includeSample(IndexEntryUpdate<?> update) {
            this.addValueToSample(update.getEntityId(), update.values()[0]);
        }

        public IndexSample sampleResult() {
            long indexSize = 0L;
            for (Set<Long> nodeIds : this.indexSamples.values()) {
                indexSize += (long)nodeIds.size();
            }
            return new IndexSample(indexSize, (long)this.indexSamples.size(), indexSize);
        }

        private void addValueToSample(long nodeId, Object propertyValue) {
            Set nodeIds = this.indexSamples.computeIfAbsent(propertyValue, k -> new HashSet());
            nodeIds.add(nodeId);
        }
    }
}

