/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.function.Function;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class DataAndSchemaTransactionSeparationIT {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();

    private static Function<GraphDatabaseService, Void> expectFailureAfterSchemaOperation(Function<GraphDatabaseService, ?> function) {
        return graphDb -> {
            graphDb.schema().indexFor(Label.label((String)"Label1")).on("key1").create();
            try {
                function.apply((GraphDatabaseService)graphDb);
                Assert.fail((String)"expected exception");
            }
            catch (Exception e) {
                Assert.assertEquals((Object)"Cannot perform data updates in a transaction that has performed schema updates.", (Object)e.getMessage());
            }
            return null;
        };
    }

    private static Function<GraphDatabaseService, Void> succeedAfterSchemaOperation(Function<GraphDatabaseService, ?> function) {
        return graphDb -> {
            graphDb.schema().indexFor(Label.label((String)"Label1")).on("key1").create();
            function.apply((GraphDatabaseService)graphDb);
            return null;
        };
    }

    @Test
    public void shouldNotAllowNodeCreationInSchemaTransaction() {
        this.db.executeAndRollback(DataAndSchemaTransactionSeparationIT.expectFailureAfterSchemaOperation(DataAndSchemaTransactionSeparationIT.createNode()));
    }

    @Test
    public void shouldNotAllowRelationshipCreationInSchemaTransaction() {
        Pair<Node, Node> nodes = this.db.executeAndCommit(DataAndSchemaTransactionSeparationIT.aPairOfNodes());
        this.db.executeAndRollback(DataAndSchemaTransactionSeparationIT.expectFailureAfterSchemaOperation(DataAndSchemaTransactionSeparationIT.relate(nodes)));
    }

    @Test
    public void shouldNotAllowPropertyWritesInSchemaTransaction() {
        Pair<Node, Node> nodes = this.db.executeAndCommit(DataAndSchemaTransactionSeparationIT.aPairOfNodes());
        Relationship relationship = this.db.executeAndCommit(DataAndSchemaTransactionSeparationIT.relate(nodes));
        for (Function operation : new Function[]{DataAndSchemaTransactionSeparationIT.propertyWrite(Node.class, (PropertyContainer)nodes.first(), "key1", "value1"), DataAndSchemaTransactionSeparationIT.propertyWrite(Relationship.class, relationship, "key1", "value1")}) {
            this.db.executeAndRollback(DataAndSchemaTransactionSeparationIT.expectFailureAfterSchemaOperation(operation));
        }
    }

    @Test
    public void shouldAllowPropertyReadsInSchemaTransaction() {
        Pair<Node, Node> nodes = this.db.executeAndCommit(DataAndSchemaTransactionSeparationIT.aPairOfNodes());
        Relationship relationship = this.db.executeAndCommit(DataAndSchemaTransactionSeparationIT.relate(nodes));
        this.db.executeAndCommit(DataAndSchemaTransactionSeparationIT.propertyWrite(Node.class, (PropertyContainer)nodes.first(), "key1", "value1"));
        this.db.executeAndCommit(DataAndSchemaTransactionSeparationIT.propertyWrite(Relationship.class, relationship, "key1", "value1"));
        for (Function operation : new Function[]{DataAndSchemaTransactionSeparationIT.propertyRead(Node.class, (PropertyContainer)nodes.first(), "key1"), DataAndSchemaTransactionSeparationIT.propertyRead(Relationship.class, relationship, "key1")}) {
            this.db.executeAndRollback(DataAndSchemaTransactionSeparationIT.succeedAfterSchemaOperation(operation));
        }
    }

    private static Function<GraphDatabaseService, Node> createNode() {
        return GraphDatabaseService::createNode;
    }

    private static <T extends PropertyContainer> Function<GraphDatabaseService, Object> propertyRead(Class<T> type, final T entity, final String key) {
        return new FailureRewrite<Object>(type.getSimpleName() + ".getProperty()"){

            @Override
            Object perform(GraphDatabaseService graphDb) {
                return entity.getProperty(key);
            }
        };
    }

    private static <T extends PropertyContainer> Function<GraphDatabaseService, Void> propertyWrite(Class<T> type, final T entity, final String key, final Object value) {
        return new FailureRewrite<Void>(type.getSimpleName() + ".setProperty()"){

            @Override
            Void perform(GraphDatabaseService graphDb) {
                entity.setProperty(key, value);
                return null;
            }
        };
    }

    private static Function<GraphDatabaseService, Pair<Node, Node>> aPairOfNodes() {
        return graphDb -> Pair.of((Object)graphDb.createNode(), (Object)graphDb.createNode());
    }

    private static Function<GraphDatabaseService, Relationship> relate(Pair<Node, Node> nodes) {
        return graphDb -> ((Node)nodes.first()).createRelationshipTo((Node)nodes.other(), RelationshipType.withName((String)"RELATED"));
    }

    private static abstract class FailureRewrite<T>
    implements Function<GraphDatabaseService, T> {
        private final String message;

        FailureRewrite(String message) {
            this.message = message;
        }

        @Override
        public T apply(GraphDatabaseService graphDb) {
            try {
                return this.perform(graphDb);
            }
            catch (AssertionError e) {
                AssertionError error = new AssertionError((Object)(this.message + ": " + ((Throwable)((Object)e)).getMessage()));
                ((Throwable)((Object)error)).setStackTrace(((Throwable)((Object)e)).getStackTrace());
                throw error;
            }
        }

        abstract T perform(GraphDatabaseService var1);
    }
}

