/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;

public class BatchingIdSequence
implements IdSequence {
    private final long startId;
    private long nextId = 0L;

    public BatchingIdSequence() {
        this(0L);
    }

    public BatchingIdSequence(long startId) {
        this.startId = startId;
        this.nextId = startId;
    }

    @Override
    public long nextId() {
        long result = this.peek();
        ++this.nextId;
        return result;
    }

    public void reset() {
        this.nextId = this.startId;
    }

    public void set(long nextId) {
        this.nextId = nextId;
    }

    public long peek() {
        if (IdValidator.isReservedId(this.nextId)) {
            ++this.nextId;
        }
        return this.nextId;
    }
}

