/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.List;

class SourceInformation
implements Cloneable {
    static final long LINE_NUMBER_MASK = 0xFFFFFFFFFFFFL;
    int sourceId;
    long lineNumber;

    SourceInformation() {
    }

    SourceInformation decode(long sourceInformation) {
        this.sourceId = (int)((sourceInformation & 0xFFFF000000000000L) >>> 48);
        this.lineNumber = sourceInformation & 0xFFFFFFFFFFFFL;
        return this;
    }

    static long encodeSourceInformation(int sourceId, long lineNumber) {
        if ((sourceId & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("Collisions in too many sources (currently at " + sourceId + ")");
        }
        if ((lineNumber & 0xFFFF000000000000L) != 0L) {
            throw new IllegalArgumentException("Collision in source with too many lines (" + lineNumber + ")");
        }
        return (long)sourceId << 48 | lineNumber;
    }

    public String describe(List<String> sourceDescriptions) {
        return sourceDescriptions.get(this.sourceId) + ":" + this.lineNumber;
    }
}

