/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.NodeType;
import org.neo4j.unsafe.impl.batchimport.staging.ForkedProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class RelationshipLinkbackStep
extends ForkedProcessorStep<RelationshipRecord[]> {
    private final NodeRelationshipCache cache;
    private final int nodeTypes;

    public RelationshipLinkbackStep(StageControl control, Configuration config, NodeRelationshipCache cache, int nodeTypes) {
        super(control, "LINK", config, 0);
        this.cache = cache;
        this.nodeTypes = nodeTypes;
    }

    @Override
    protected void forkedProcess(int id, int processors, RelationshipRecord[] batch) {
        for (int i = batch.length - 1; i >= 0; --i) {
            RelationshipRecord item = batch[i];
            if (item == null || !item.inUse() || this.process(item, id, processors)) continue;
            batch[i] = null;
        }
    }

    public boolean process(RelationshipRecord record, int id, int processors) {
        boolean processSecond;
        boolean processFirst = record.getFirstNode() % (long)processors == (long)id;
        boolean bl = processSecond = record.getSecondNode() % (long)processors == (long)id;
        if (!processFirst && !processSecond) {
            return true;
        }
        boolean firstIsDense = this.cache.isDense(record.getFirstNode());
        boolean changed = false;
        boolean isLoop = record.getFirstNode() == record.getSecondNode();
        int typeId = record.getType();
        if (isLoop) {
            if (NodeType.matchesDense(this.nodeTypes, firstIsDense)) {
                if (processFirst) {
                    long prevRel = this.cache.getAndPutRelationship(record.getFirstNode(), typeId, Direction.BOTH, record.getId(), false);
                    if (prevRel == -1L) {
                        record.setFirstInFirstChain(true);
                        record.setFirstInSecondChain(true);
                        prevRel = this.cache.getCount(record.getFirstNode(), typeId, Direction.BOTH);
                    }
                    record.setFirstPrevRel(prevRel);
                    record.setSecondPrevRel(prevRel);
                }
                changed = true;
            }
        } else {
            boolean secondIsDense;
            if (NodeType.matchesDense(this.nodeTypes, firstIsDense)) {
                if (processFirst) {
                    long firstPrevRel = this.cache.getAndPutRelationship(record.getFirstNode(), typeId, Direction.OUTGOING, record.getId(), false);
                    if (firstPrevRel == -1L) {
                        record.setFirstInFirstChain(true);
                        firstPrevRel = this.cache.getCount(record.getFirstNode(), typeId, Direction.OUTGOING);
                    }
                    record.setFirstPrevRel(firstPrevRel);
                }
                changed = true;
            }
            if (NodeType.matchesDense(this.nodeTypes, secondIsDense = this.cache.isDense(record.getSecondNode()))) {
                if (processSecond) {
                    long secondPrevRel = this.cache.getAndPutRelationship(record.getSecondNode(), typeId, Direction.INCOMING, record.getId(), false);
                    if (secondPrevRel == -1L) {
                        record.setFirstInSecondChain(true);
                        secondPrevRel = this.cache.getCount(record.getSecondNode(), typeId, Direction.INCOMING);
                    }
                    record.setSecondPrevRel(secondPrevRel);
                }
                changed = true;
            }
        }
        return changed;
    }
}

