/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.function.Consumer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;

public class CheckPointThresholds {
    public static CheckPointThreshold or(final CheckPointThreshold ... thresholds) {
        return new CheckPointThreshold(){

            @Override
            public void initialize(long transactionId) {
                for (CheckPointThreshold threshold : thresholds) {
                    threshold.initialize(transactionId);
                }
            }

            @Override
            public boolean isCheckPointingNeeded(long transactionId, Consumer<String> consumer) {
                for (CheckPointThreshold threshold : thresholds) {
                    if (!threshold.isCheckPointingNeeded(transactionId, consumer)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void checkPointHappened(long transactionId) {
                for (CheckPointThreshold threshold : thresholds) {
                    threshold.checkPointHappened(transactionId);
                }
            }
        };
    }

    private CheckPointThresholds() {
    }
}

