/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.cursor.IOCursor;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;

public class LogEntryCursor
implements IOCursor<LogEntry> {
    private final LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader;
    private final ReadableClosablePositionAwareChannel channel;
    private final LogPositionMarker position = new LogPositionMarker();
    private LogEntry entry;

    public LogEntryCursor(LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader, ReadableClosablePositionAwareChannel channel) {
        this.logEntryReader = logEntryReader;
        this.channel = channel;
    }

    public LogEntry get() {
        return this.entry;
    }

    public boolean next() throws IOException {
        this.entry = this.logEntryReader.readLogEntry(this.channel);
        return this.entry != null;
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public long getCurrentLogVersion() throws IOException {
        this.channel.getCurrentPosition(this.position);
        return this.position.getLogVersion();
    }
}

