/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class PopulatingIndexProxy
implements IndexProxy {
    private final IndexDescriptor descriptor;
    private final SchemaIndexProvider.Descriptor providerDescriptor;
    private final IndexConfiguration configuration;
    private final IndexPopulationJob job;

    public PopulatingIndexProxy(IndexDescriptor descriptor, IndexConfiguration configuration, SchemaIndexProvider.Descriptor providerDescriptor, IndexPopulationJob job) {
        this.descriptor = descriptor;
        this.configuration = configuration;
        this.providerDescriptor = providerDescriptor;
        this.job = job;
    }

    @Override
    public void start() {
    }

    @Override
    public IndexUpdater newUpdater(final IndexUpdateMode mode) {
        switch (mode) {
            case ONLINE: 
            case RECOVERY: {
                return new PopulatingIndexUpdater(){

                    @Override
                    public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException {
                        PopulatingIndexProxy.this.job.update(update);
                    }
                };
            }
        }
        return new PopulatingIndexUpdater(){

            @Override
            public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException {
                throw new IllegalArgumentException("Unsupported update mode: " + (Object)((Object)mode));
            }
        };
    }

    @Override
    public Future<Void> drop() {
        return this.job.cancel();
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.POPULATING;
    }

    @Override
    public void force() {
    }

    @Override
    public Future<Void> close() {
        return this.job.cancel();
    }

    @Override
    public IndexReader newReader() throws IndexNotFoundKernelException {
        throw new IndexNotFoundKernelException("Index is still populating: " + this.job);
    }

    @Override
    public boolean awaitStoreScanCompleted() throws IndexPopulationFailedKernelException, InterruptedException {
        this.job.awaitCompletion();
        return true;
    }

    @Override
    public void activate() throws IndexActivationFailedKernelException {
        throw new IllegalStateException("Cannot activate index while it is still populating: " + this.job);
    }

    @Override
    public void validate() {
        throw new IllegalStateException("Cannot validate index while it is still populating: " + this.job);
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        return Iterators.emptyIterator();
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        throw new IllegalStateException(this + " is POPULATING");
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return this.job.getPopulationProgress();
    }

    @Override
    public IndexConfiguration config() {
        return this.configuration;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[job:" + this.job + "]";
    }

    private abstract class PopulatingIndexUpdater
    implements IndexUpdater {
        private PopulatingIndexUpdater() {
        }

        @Override
        public void close() throws IOException, IndexEntryConflictException {
        }

        @Override
        public void remove(PrimitiveLongSet nodeIds) {
            throw new UnsupportedOperationException("Should not remove() from populating index.");
        }
    }
}

