/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.concurrent.Callable;
import org.neo4j.kernel.api.properties.ArrayValue;
import org.neo4j.kernel.api.properties.BooleanArrayProperty;
import org.neo4j.kernel.api.properties.CharArrayProperty;
import org.neo4j.kernel.api.properties.FloatingPointArrayProperty;
import org.neo4j.kernel.api.properties.IntegralArrayProperty;
import org.neo4j.kernel.api.properties.LazyProperty;
import org.neo4j.kernel.api.properties.StringArrayProperty;

class LazyArrayProperty
extends LazyProperty<Object> {
    private Type type;

    LazyArrayProperty(int propertyKeyId, Callable<?> producer) {
        super(propertyKeyId, producer);
    }

    @Override
    protected Object produceValue() {
        Object value = super.produceValue();
        this.type = Type.from(value);
        return value;
    }

    @Override
    public boolean valueEquals(Object value) {
        Object myValue = this.value();
        return this.type.equals(myValue, value);
    }

    @Override
    int valueHash() {
        Object myValue = this.value();
        return this.type.hashCode(myValue);
    }

    @Override
    protected Object castAndPrepareForReturn(Object value) {
        return this.type.clone(value);
    }

    private static enum Type {
        INT{

            @Override
            int hashCode(Object array) {
                return IntegralArrayProperty.hash(new ArrayValue.IntArray((int[])array));
            }

            @Override
            boolean equals(Object value, Object other) {
                return IntegralArrayProperty.valueEquals(new ArrayValue.IntArray((int[])value), other);
            }

            @Override
            Object clone(Object array) {
                return ((int[])array).clone();
            }
        }
        ,
        LONG{

            @Override
            int hashCode(Object array) {
                return IntegralArrayProperty.hash(new ArrayValue.LongArray((long[])array));
            }

            @Override
            boolean equals(Object value, Object other) {
                return IntegralArrayProperty.valueEquals(new ArrayValue.LongArray((long[])value), other);
            }

            @Override
            Object clone(Object array) {
                return ((long[])array).clone();
            }
        }
        ,
        BOOLEAN{

            @Override
            int hashCode(Object array) {
                return BooleanArrayProperty.hash((boolean[])array);
            }

            @Override
            boolean equals(Object value, Object other) {
                return BooleanArrayProperty.valueEquals((boolean[])value, other);
            }

            @Override
            Object clone(Object array) {
                return ((boolean[])array).clone();
            }
        }
        ,
        BYTE{

            @Override
            int hashCode(Object array) {
                return IntegralArrayProperty.hash(new ArrayValue.ByteArray((byte[])array));
            }

            @Override
            boolean equals(Object value, Object other) {
                return IntegralArrayProperty.valueEquals(new ArrayValue.ByteArray((byte[])value), other);
            }

            @Override
            Object clone(Object array) {
                return ((byte[])array).clone();
            }
        }
        ,
        DOUBLE{

            @Override
            int hashCode(Object array) {
                return FloatingPointArrayProperty.hash(new ArrayValue.DoubleArray((double[])array));
            }

            @Override
            boolean equals(Object value, Object other) {
                return FloatingPointArrayProperty.valueEquals(new ArrayValue.DoubleArray((double[])value), other);
            }

            @Override
            Object clone(Object array) {
                return ((double[])array).clone();
            }
        }
        ,
        STRING{

            @Override
            int hashCode(Object array) {
                return StringArrayProperty.hash((String[])array);
            }

            @Override
            boolean equals(Object value, Object other) {
                return StringArrayProperty.valueEquals((String[])value, other);
            }

            @Override
            Object clone(Object array) {
                return ((String[])array).clone();
            }
        }
        ,
        SHORT{

            @Override
            int hashCode(Object array) {
                return IntegralArrayProperty.hash(new ArrayValue.ShortArray((short[])array));
            }

            @Override
            boolean equals(Object value, Object other) {
                return IntegralArrayProperty.valueEquals(new ArrayValue.ShortArray((short[])value), other);
            }

            @Override
            Object clone(Object array) {
                return ((short[])array).clone();
            }
        }
        ,
        CHAR{

            @Override
            int hashCode(Object array) {
                return CharArrayProperty.hash((char[])array);
            }

            @Override
            boolean equals(Object value, Object other) {
                return CharArrayProperty.valueEquals((char[])value, other);
            }

            @Override
            Object clone(Object array) {
                return ((char[])array).clone();
            }
        }
        ,
        FLOAT{

            @Override
            int hashCode(Object array) {
                return FloatingPointArrayProperty.hash(new ArrayValue.FloatArray((float[])array));
            }

            @Override
            boolean equals(Object value, Object other) {
                return FloatingPointArrayProperty.valueEquals(new ArrayValue.FloatArray((float[])value), other);
            }

            @Override
            Object clone(Object array) {
                return ((float[])array).clone();
            }
        };


        abstract int hashCode(Object var1);

        abstract boolean equals(Object var1, Object var2);

        abstract Object clone(Object var1);

        public static Type from(Object array) {
            if (!array.getClass().isArray()) {
                throw new IllegalArgumentException(array + " is not an array, it's a " + array.getClass());
            }
            if (array instanceof int[]) {
                return INT;
            }
            if (array instanceof long[]) {
                return LONG;
            }
            if (array instanceof boolean[]) {
                return BOOLEAN;
            }
            if (array instanceof byte[]) {
                return BYTE;
            }
            if (array instanceof double[]) {
                return DOUBLE;
            }
            if (array instanceof String[]) {
                return STRING;
            }
            if (array instanceof short[]) {
                return SHORT;
            }
            if (array instanceof char[]) {
                return CHAR;
            }
            if (array instanceof float[]) {
                return FLOAT;
            }
            throw new IllegalArgumentException("Unrecognized array type " + array.getClass().getComponentType());
        }
    }
}

