/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.RecordProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;

public class RelationshipLinkbackProcessor
implements RecordProcessor<RelationshipRecord> {
    private final NodeRelationshipCache cache;
    private final boolean denseNodes;

    public RelationshipLinkbackProcessor(NodeRelationshipCache cache, boolean denseNodes) {
        this.cache = cache;
        this.denseNodes = denseNodes;
    }

    @Override
    public boolean process(RelationshipRecord record) {
        boolean isLoop = record.getFirstNode() == record.getSecondNode();
        boolean firstIsDense = this.cache.isDense(record.getFirstNode());
        boolean changed = false;
        if (isLoop) {
            if (firstIsDense == this.denseNodes) {
                long prevRel = this.cache.getAndPutRelationship(record.getFirstNode(), Direction.BOTH, record.getId(), false);
                if (prevRel == -1L) {
                    record.setFirstInFirstChain(true);
                    record.setFirstInSecondChain(true);
                    prevRel = this.cache.getCount(record.getFirstNode(), Direction.BOTH);
                }
                record.setFirstPrevRel(prevRel);
                record.setSecondPrevRel(prevRel);
                changed = true;
            }
        } else {
            boolean secondIsDense;
            if (firstIsDense == this.denseNodes) {
                long firstPrevRel = this.cache.getAndPutRelationship(record.getFirstNode(), Direction.OUTGOING, record.getId(), false);
                if (firstPrevRel == -1L) {
                    record.setFirstInFirstChain(true);
                    firstPrevRel = this.cache.getCount(record.getFirstNode(), Direction.OUTGOING);
                }
                record.setFirstPrevRel(firstPrevRel);
                changed = true;
            }
            if ((secondIsDense = this.cache.isDense(record.getSecondNode())) == this.denseNodes) {
                long secondPrevRel = this.cache.getAndPutRelationship(record.getSecondNode(), Direction.INCOMING, record.getId(), false);
                if (secondPrevRel == -1L) {
                    record.setFirstInSecondChain(true);
                    secondPrevRel = this.cache.getCount(record.getSecondNode(), Direction.INCOMING);
                }
                record.setSecondPrevRel(secondPrevRel);
                changed = true;
            }
        }
        return changed;
    }

    @Override
    public void done() {
    }
}

