/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.impl.util.NumberAwareStringComparator;
import org.neo4j.kernel.impl.util.Validators;

public class Converters {
    public static final Comparator<File> BY_FILE_NAME = (o1, o2) -> o1.getName().compareTo(o2.getName());
    public static final Comparator<File> BY_FILE_NAME_WITH_CLEVER_NUMBERS = (o1, o2) -> NumberAwareStringComparator.INSTANCE.compare(o1.getAbsolutePath(), o2.getAbsolutePath());

    public static <T> Function<String, T> mandatory() {
        return key -> {
            throw new IllegalArgumentException("Missing argument '" + key + "'");
        };
    }

    public static <T> Function<String, T> optional() {
        return from -> null;
    }

    public static <T> Function<String, T> withDefault(T defaultValue) {
        return from -> defaultValue;
    }

    public static Function<String, File> toFile() {
        return File::new;
    }

    public static Function<String, Path> toPath() {
        return x$0 -> Paths.get(x$0, new String[0]);
    }

    public static Function<String, String> identity() {
        return s -> s;
    }

    public static Function<String, File[]> regexFiles(boolean cleverNumberRegexSort) {
        return name -> {
            Comparator<File> sorting = cleverNumberRegexSort ? BY_FILE_NAME_WITH_CLEVER_NUMBERS : BY_FILE_NAME;
            List<File> files = Validators.matchingFiles(new File((String)name));
            Collections.sort(files, sorting);
            return files.toArray(new File[files.size()]);
        };
    }

    public static Function<String, File[]> toFiles(String delimiter, Function<String, File[]> eachFileConverter) {
        return from -> {
            if (from == null) {
                return new File[0];
            }
            String[] names = from.split(delimiter);
            ArrayList<File> files = new ArrayList<File>();
            for (String name : names) {
                for (File file : (File[])eachFileConverter.apply(name)) {
                    files.add(file);
                }
            }
            return files.toArray(new File[files.size()]);
        };
    }

    public static Function<String, Integer> toInt() {
        return Integer::new;
    }

    public static Function<String, HostnamePort> toHostnamePort(HostnamePort defaultAddress) {
        return from -> {
            if (!from.contains(":")) {
                from = from + ":" + defaultAddress.getPort();
            }
            if (from.endsWith(":")) {
                from = from + defaultAddress.getPort();
            }
            if (from.startsWith(":")) {
                from = defaultAddress.getHost() + from;
            }
            String[] parts = from.split(":");
            return new HostnamePort(parts[0], Integer.parseInt(parts[1]));
        };
    }
}

