/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class Loaders {
    private final RecordAccess.Loader<Long, NodeRecord, Void> nodeLoader;
    private final RecordAccess.Loader<Long, PropertyRecord, PrimitiveRecord> propertyLoader;
    private final RecordAccess.Loader<Long, RelationshipRecord, Void> relationshipLoader;
    private final RecordAccess.Loader<Long, RelationshipGroupRecord, Integer> relationshipGroupLoader;
    private final RecordAccess.Loader<Long, SchemaRecord, SchemaRule> schemaRuleLoader;
    private final RecordAccess.Loader<Integer, PropertyKeyTokenRecord, Void> propertyKeyTokenLoader;
    private final RecordAccess.Loader<Integer, LabelTokenRecord, Void> labelTokenLoader;
    private final RecordAccess.Loader<Integer, RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader;

    public Loaders(NeoStores neoStores) {
        this(neoStores.getNodeStore(), neoStores.getPropertyStore(), neoStores.getRelationshipStore(), neoStores.getRelationshipGroupStore(), neoStores.getPropertyKeyTokenStore(), neoStores.getRelationshipTypeTokenStore(), neoStores.getLabelTokenStore(), neoStores.getSchemaStore());
    }

    public Loaders(RecordStore<NodeRecord> nodeStore, PropertyStore propertyStore, RecordStore<RelationshipRecord> relationshipStore, RecordStore<RelationshipGroupRecord> relationshipGroupStore, RecordStore<PropertyKeyTokenRecord> propertyKeyTokenStore, RecordStore<RelationshipTypeTokenRecord> relationshipTypeTokenStore, RecordStore<LabelTokenRecord> labelTokenStore, SchemaStore schemaStore) {
        this.nodeLoader = Loaders.nodeLoader(nodeStore);
        this.propertyLoader = Loaders.propertyLoader(propertyStore);
        this.relationshipLoader = Loaders.relationshipLoader(relationshipStore);
        this.relationshipGroupLoader = Loaders.relationshipGroupLoader(relationshipGroupStore);
        this.schemaRuleLoader = Loaders.schemaRuleLoader(schemaStore);
        this.propertyKeyTokenLoader = Loaders.propertyKeyTokenLoader(propertyKeyTokenStore);
        this.labelTokenLoader = Loaders.labelTokenLoader(labelTokenStore);
        this.relationshipTypeTokenLoader = Loaders.relationshipTypeTokenLoader(relationshipTypeTokenStore);
    }

    public RecordAccess.Loader<Long, NodeRecord, Void> nodeLoader() {
        return this.nodeLoader;
    }

    public RecordAccess.Loader<Long, PropertyRecord, PrimitiveRecord> propertyLoader() {
        return this.propertyLoader;
    }

    public RecordAccess.Loader<Long, RelationshipRecord, Void> relationshipLoader() {
        return this.relationshipLoader;
    }

    public RecordAccess.Loader<Long, RelationshipGroupRecord, Integer> relationshipGroupLoader() {
        return this.relationshipGroupLoader;
    }

    public RecordAccess.Loader<Long, SchemaRecord, SchemaRule> schemaRuleLoader() {
        return this.schemaRuleLoader;
    }

    public RecordAccess.Loader<Integer, PropertyKeyTokenRecord, Void> propertyKeyTokenLoader() {
        return this.propertyKeyTokenLoader;
    }

    public RecordAccess.Loader<Integer, LabelTokenRecord, Void> labelTokenLoader() {
        return this.labelTokenLoader;
    }

    public RecordAccess.Loader<Integer, RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader() {
        return this.relationshipTypeTokenLoader;
    }

    public static RecordAccess.Loader<Long, NodeRecord, Void> nodeLoader(final RecordStore<NodeRecord> store) {
        return new RecordAccess.Loader<Long, NodeRecord, Void>(){

            @Override
            public NodeRecord newUnused(Long key, Void additionalData) {
                return Loaders.andMarkAsCreated(new NodeRecord(key));
            }

            @Override
            public NodeRecord load(Long key, Void additionalData) {
                return (NodeRecord)store.getRecord(key, store.newRecord(), RecordLoad.NORMAL);
            }

            @Override
            public void ensureHeavy(NodeRecord record) {
                store.ensureHeavy(record);
            }

            @Override
            public NodeRecord clone(NodeRecord nodeRecord) {
                return nodeRecord.clone();
            }
        };
    }

    public static RecordAccess.Loader<Long, PropertyRecord, PrimitiveRecord> propertyLoader(final PropertyStore store) {
        return new RecordAccess.Loader<Long, PropertyRecord, PrimitiveRecord>(){

            @Override
            public PropertyRecord newUnused(Long key, PrimitiveRecord additionalData) {
                PropertyRecord record = new PropertyRecord(key);
                this.setOwner(record, additionalData);
                return Loaders.andMarkAsCreated(record);
            }

            private void setOwner(PropertyRecord record, PrimitiveRecord owner) {
                if (owner != null) {
                    owner.setIdTo(record);
                }
            }

            @Override
            public PropertyRecord load(Long key, PrimitiveRecord additionalData) {
                PropertyRecord record = store.getRecord(key, store.newRecord(), RecordLoad.NORMAL);
                this.setOwner(record, additionalData);
                return record;
            }

            @Override
            public void ensureHeavy(PropertyRecord record) {
                for (PropertyBlock block : record) {
                    store.ensureHeavy(block);
                }
            }

            @Override
            public PropertyRecord clone(PropertyRecord propertyRecord) {
                return propertyRecord.clone();
            }
        };
    }

    public static RecordAccess.Loader<Long, RelationshipRecord, Void> relationshipLoader(final RecordStore<RelationshipRecord> store) {
        return new RecordAccess.Loader<Long, RelationshipRecord, Void>(){

            @Override
            public RelationshipRecord newUnused(Long key, Void additionalData) {
                return Loaders.andMarkAsCreated(new RelationshipRecord(key));
            }

            @Override
            public RelationshipRecord load(Long key, Void additionalData) {
                return (RelationshipRecord)store.getRecord(key, store.newRecord(), RecordLoad.NORMAL);
            }

            @Override
            public void ensureHeavy(RelationshipRecord record) {
            }

            @Override
            public RelationshipRecord clone(RelationshipRecord relationshipRecord) {
                return relationshipRecord.clone();
            }
        };
    }

    public static RecordAccess.Loader<Long, RelationshipGroupRecord, Integer> relationshipGroupLoader(final RecordStore<RelationshipGroupRecord> store) {
        return new RecordAccess.Loader<Long, RelationshipGroupRecord, Integer>(){

            @Override
            public RelationshipGroupRecord newUnused(Long key, Integer type) {
                RelationshipGroupRecord record = new RelationshipGroupRecord(key);
                record.setType(type);
                return Loaders.andMarkAsCreated(record);
            }

            @Override
            public RelationshipGroupRecord load(Long key, Integer type) {
                return (RelationshipGroupRecord)store.getRecord(key, store.newRecord(), RecordLoad.NORMAL);
            }

            @Override
            public void ensureHeavy(RelationshipGroupRecord record) {
            }

            @Override
            public RelationshipGroupRecord clone(RelationshipGroupRecord record) {
                return record.clone();
            }
        };
    }

    public static RecordAccess.Loader<Long, SchemaRecord, SchemaRule> schemaRuleLoader(final SchemaStore store) {
        return new RecordAccess.Loader<Long, SchemaRecord, SchemaRule>(){

            @Override
            public SchemaRecord newUnused(Long key, SchemaRule additionalData) {
                return new SchemaRecord(store.allocateFrom(additionalData));
            }

            @Override
            public SchemaRecord load(Long key, SchemaRule additionalData) {
                return new SchemaRecord(store.getRecords(key, RecordLoad.NORMAL));
            }

            @Override
            public void ensureHeavy(SchemaRecord records) {
                for (DynamicRecord record : records) {
                    store.ensureHeavy(record);
                }
            }

            @Override
            public SchemaRecord clone(SchemaRecord records) {
                return records.clone();
            }
        };
    }

    public static RecordAccess.Loader<Integer, PropertyKeyTokenRecord, Void> propertyKeyTokenLoader(final RecordStore<PropertyKeyTokenRecord> store) {
        return new RecordAccess.Loader<Integer, PropertyKeyTokenRecord, Void>(){

            @Override
            public PropertyKeyTokenRecord newUnused(Integer key, Void additionalData) {
                return Loaders.andMarkAsCreated(new PropertyKeyTokenRecord(key));
            }

            @Override
            public PropertyKeyTokenRecord load(Integer key, Void additionalData) {
                return (PropertyKeyTokenRecord)store.getRecord(key.intValue(), store.newRecord(), RecordLoad.NORMAL);
            }

            @Override
            public void ensureHeavy(PropertyKeyTokenRecord record) {
                store.ensureHeavy(record);
            }

            @Override
            public PropertyKeyTokenRecord clone(PropertyKeyTokenRecord record) {
                return record.clone();
            }
        };
    }

    public static RecordAccess.Loader<Integer, LabelTokenRecord, Void> labelTokenLoader(final RecordStore<LabelTokenRecord> store) {
        return new RecordAccess.Loader<Integer, LabelTokenRecord, Void>(){

            @Override
            public LabelTokenRecord newUnused(Integer key, Void additionalData) {
                return Loaders.andMarkAsCreated(new LabelTokenRecord(key));
            }

            @Override
            public LabelTokenRecord load(Integer key, Void additionalData) {
                return (LabelTokenRecord)store.getRecord(key.intValue(), store.newRecord(), RecordLoad.NORMAL);
            }

            @Override
            public void ensureHeavy(LabelTokenRecord record) {
                store.ensureHeavy(record);
            }

            @Override
            public LabelTokenRecord clone(LabelTokenRecord record) {
                return record.clone();
            }
        };
    }

    public static RecordAccess.Loader<Integer, RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader(final RecordStore<RelationshipTypeTokenRecord> store) {
        return new RecordAccess.Loader<Integer, RelationshipTypeTokenRecord, Void>(){

            @Override
            public RelationshipTypeTokenRecord newUnused(Integer key, Void additionalData) {
                return Loaders.andMarkAsCreated(new RelationshipTypeTokenRecord(key));
            }

            @Override
            public RelationshipTypeTokenRecord load(Integer key, Void additionalData) {
                return (RelationshipTypeTokenRecord)store.getRecord(key.intValue(), store.newRecord(), RecordLoad.NORMAL);
            }

            @Override
            public void ensureHeavy(RelationshipTypeTokenRecord record) {
                store.ensureHeavy(record);
            }

            @Override
            public RelationshipTypeTokenRecord clone(RelationshipTypeTokenRecord record) {
                return record.clone();
            }
        };
    }

    protected static <RECORD extends AbstractBaseRecord> RECORD andMarkAsCreated(RECORD record) {
        record.setCreated();
        return record;
    }
}

