/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdSequence;

public class BatchingIdSequenceTest {
    @Test
    public void ShouldSkipNullId() throws Exception {
        BatchingIdSequence idSequence = new BatchingIdSequence();
        idSequence.set(0xFFFFFFFEL);
        Assert.assertEquals((long)0xFFFFFFFEL, (long)idSequence.peek());
        Assert.assertEquals((long)0xFFFFFFFEL, (long)idSequence.nextId());
        Assert.assertEquals((long)0x100000000L, (long)idSequence.peek());
        Assert.assertEquals((long)0x100000000L, (long)idSequence.nextId());
        idSequence.set(0xFFFFFFFFL);
        Assert.assertEquals((long)0x100000000L, (long)idSequence.peek());
        Assert.assertEquals((long)0x100000000L, (long)idSequence.nextId());
    }

    @Test
    public void resetShouldSetDefault() throws Exception {
        BatchingIdSequence idSequence = new BatchingIdSequence();
        idSequence.set(99L);
        Assert.assertEquals((long)99L, (long)idSequence.peek());
        Assert.assertEquals((long)99L, (long)idSequence.nextId());
        Assert.assertEquals((long)100L, (long)idSequence.peek());
        idSequence.reset();
        Assert.assertEquals((long)0L, (long)idSequence.peek());
        Assert.assertEquals((long)0L, (long)idSequence.nextId());
        Assert.assertEquals((long)1L, (long)idSequence.peek());
    }
}

