/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.csv.reader.Readables;
import org.neo4j.function.Suppliers;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Decorator;
import org.neo4j.unsafe.impl.batchimport.input.csv.DeserializerFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputEntityDeserializer;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputGroupsDeserializer;

public class InputGroupsDeserializerTest {
    @Test
    public void shouldBeAbleToAskForSourceInformationEvenBetweenTwoSources() throws Exception {
        List<DataFactory> data = Arrays.asList(this.data(":ID\n1"), this.data("2"));
        AtomicInteger flips = new AtomicInteger();
        AtomicReference<Object> deserializerTestHack = new AtomicReference<Object>(null);
        InputGroupsDeserializer deserializer = new InputGroupsDeserializer(data.iterator(), DataFactories.defaultFormatNodeFileHeader(), this.lowBufferSize(Configuration.COMMAS, true), IdType.INTEGER, Runtime.getRuntime().availableProcessors(), 1, (header, stream, decorator, validator) -> {
            if (flips.get() == 0) {
                Assert.assertNotNull((Object)((InputGroupsDeserializer)deserializerTestHack.get()).sourceDescription());
            } else {
                Assert.assertEquals((Object)("" + flips.get()), (Object)((InputGroupsDeserializer)deserializerTestHack.get()).sourceDescription());
            }
            flips.incrementAndGet();
            InputEntityDeserializer result = (InputEntityDeserializer)Mockito.mock(InputEntityDeserializer.class);
            Mockito.when((Object)result.sourceDescription()).thenReturn((Object)String.valueOf(flips.get()));
            ((InputEntityDeserializer)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    stream.close();
                    return null;
                }
            }).when((Object)result)).close();
            return result;
        }, Validators.emptyValidator(), InputNode.class);
        deserializerTestHack.set(deserializer);
        Iterators.count((Iterator)deserializer);
        Assert.assertEquals((long)2L, (long)flips.get());
        deserializer.close();
    }

    @Test
    public void shouldCoordinateGroupCreationForParallelProcessing() throws Exception {
        ArrayList<DataFactory<InputNode>> data = new ArrayList<DataFactory<InputNode>>();
        int processors = Runtime.getRuntime().availableProcessors();
        for (int i = 0; i < processors; ++i) {
            StringBuilder builder = new StringBuilder(":ID(Group" + i + ")");
            for (int j = 0; j < 100; ++j) {
                builder.append("\n" + j);
            }
            data.add(this.data(builder.toString()));
        }
        Groups groups = new Groups();
        IdType idType = IdType.INTEGER;
        Collector badCollector = (Collector)Mockito.mock(Collector.class);
        Configuration config = this.lowBufferSize(Configuration.COMMAS, false);
        InputGroupsDeserializer.DeserializerFactory factory = DeserializerFactories.defaultNodeDeserializer((Groups)groups, (Configuration)config, (IdType)idType, (Collector)badCollector);
        try (InputGroupsDeserializer deserializer = new InputGroupsDeserializer(data.iterator(), DataFactories.defaultFormatNodeFileHeader(), config, idType, processors, processors, factory, Validators.emptyValidator(), InputNode.class);){
            Iterators.count((Iterator)deserializer);
        }
        Assert.assertEquals((long)processors, (long)groups.getOrCreate("LastOne").id());
        boolean[] seen = new boolean[processors];
        for (int i = 0; i < processors; ++i) {
            String groupName = "Group" + i;
            groups.getOrCreate(groupName);
            Assert.assertFalse((boolean)seen[i]);
            seen[i] = true;
        }
    }

    private Configuration lowBufferSize(Configuration conf, final boolean multilineFields) {
        return new Configuration.Overridden(conf){

            public int bufferSize() {
                return 100;
            }

            public boolean multilineFields() {
                return multilineFields;
            }
        };
    }

    private DataFactory<InputNode> data(String string) {
        return DataFactories.data((Decorator)InputEntityDecorators.NO_NODE_DECORATOR, (Supplier)Suppliers.singleton((Object)Readables.wrap((Reader)new StringReader(string))));
    }
}

