/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.SourceInformation;

public class SourceInformationTest {
    @Test
    public void shouldEncodeAndDecodeInformation() throws Exception {
        SourceInformation codec = new SourceInformation();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 100; ++i) {
            int sourceId = ((Random)random).nextInt(65536);
            long lineNumber = Math.abs(((Random)random).nextLong()) & 0xFFFFFFFFFFFFL;
            long encoded = SourceInformation.encodeSourceInformation((int)sourceId, (long)lineNumber);
            codec.decode(encoded);
            String hint = String.format("sourceId:%d, lineNumber:%d --> %d --> sourceId:%d, lineNumber:%d", sourceId, lineNumber, encoded, codec.sourceId, codec.lineNumber);
            Assert.assertEquals((String)hint, (long)sourceId, (long)codec.sourceId);
            Assert.assertEquals((String)hint, (long)lineNumber, (long)codec.lineNumber);
        }
    }
}

