/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Function;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

@RunWith(value=Parameterized.class)
public class NumberArrayTest {
    private static final int INDEXES = 50000;
    @Rule
    public RandomRule random = new RandomRule();
    @Parameterized.Parameter(value=0)
    public NumberArray<?> array;
    @Parameterized.Parameter(value=1)
    public Function<RandomRule, Object> valueGenerator;
    @Parameterized.Parameter(value=2)
    public Writer writer;
    @Parameterized.Parameter(value=3)
    public Reader reader;

    @Parameterized.Parameters
    public static Collection<Object[]> arrays() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (NumberArrayFactory factory : (NumberArrayFactory[])ArrayUtil.array((Object[])new NumberArrayFactory[]{NumberArrayFactory.HEAP, NumberArrayFactory.OFF_HEAP, NumberArrayFactory.AUTO, NumberArrayFactory.CHUNKED_FIXED_SIZE})) {
            list.add(NumberArrayTest.line(factory.newIntArray(50000L, -1), random -> random.nextInt(1000000000), (array, index, value) -> array.set((long)index, ((Integer)value).intValue()), (array, index) -> array.get((long)index)));
            list.add(NumberArrayTest.line(factory.newDynamicIntArray(500L, -1), random -> random.nextInt(1000000000), (array, index, value) -> array.set((long)index, ((Integer)value).intValue()), (array, index) -> array.get((long)index)));
            list.add(NumberArrayTest.line(factory.newLongArray(50000L, -1L), random -> random.nextLong(1000000000L), (array, index, value) -> array.set((long)index, ((Long)value).longValue()), (array, index) -> array.get((long)index)));
            list.add(NumberArrayTest.line(factory.newDynamicLongArray(500L, -1L), random -> random.nextLong(1000000000L), (array, index, value) -> array.set((long)index, ((Long)value).longValue()), (array, index) -> array.get((long)index)));
            list.add(NumberArrayTest.line(factory.newByteArray(50000L, new byte[]{-1, -1, -1, -1, -1}), random -> random.nextInt(1000000000), (array, index, value) -> array.setInt((long)index, 1, ((Integer)value).intValue()), (array, index) -> array.getInt((long)index, 1)));
            list.add(NumberArrayTest.line(factory.newDynamicByteArray(500L, new byte[]{-1, -1, -1, -1, -1}), random -> random.nextInt(1000000000), (array, index, value) -> array.setInt((long)index, 1, ((Integer)value).intValue()), (array, index) -> array.getInt((long)index, 1)));
        }
        return list;
    }

    private static <N extends NumberArray<N>> Object[] line(N array, Function<RandomRule, Object> valueGenerator, Writer<N> writer, Reader<N> reader) {
        return new Object[]{array, valueGenerator, writer, reader};
    }

    @Test
    public void shouldGetAndSetRandomItems() throws Exception {
        HashMap<Integer, Object> key = new HashMap<Integer, Object>();
        Object defaultValue = this.reader.read(this.array, 0);
        for (int i = 0; i < 100000; ++i) {
            int index = this.random.nextInt(50000);
            Object value = this.valueGenerator.apply(this.random);
            this.writer.write(i % 2 == 0 ? this.array : this.array.at((long)index), index, value);
            key.put(index, value);
        }
        for (int index = 0; index < 50000; ++index) {
            Object value = this.reader.read(index % 2 == 0 ? this.array : this.array.at((long)index), index);
            Object expectedValue = key.containsKey(index) ? key.get(index) : defaultValue;
            Assert.assertEquals((Object)expectedValue, (Object)value);
        }
    }

    @After
    public void after() {
        this.array.close();
    }

    @FunctionalInterface
    static interface Reader<N extends NumberArray<N>> {
        public Object read(N var1, int var2);
    }

    @FunctionalInterface
    static interface Writer<N extends NumberArray<N>> {
        public void write(N var1, int var2, Object var3);
    }
}

