/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

@RunWith(value=Parameterized.class)
public class ByteArrayTest {
    private static final byte[] DEFAULT = new byte[25];
    @Parameterized.Parameter
    public Supplier<ByteArray> factory;
    private ByteArray array;

    @Parameterized.Parameters
    public static Collection<Supplier<ByteArray>> data() {
        return Arrays.asList(() -> NumberArrayFactory.HEAP.newByteArray(1000L, DEFAULT), () -> NumberArrayFactory.HEAP.newDynamicByteArray(100L, DEFAULT), () -> NumberArrayFactory.OFF_HEAP.newByteArray(1000L, DEFAULT), () -> NumberArrayFactory.OFF_HEAP.newDynamicByteArray(100L, DEFAULT), () -> NumberArrayFactory.AUTO.newByteArray(1000L, DEFAULT), () -> NumberArrayFactory.AUTO.newDynamicByteArray(100L, DEFAULT));
    }

    @Before
    public void before() {
        this.array = this.factory.get();
    }

    @After
    public void after() {
        this.array.close();
    }

    @Test
    public void shouldSetAndGetBasicTypes() throws Exception {
        this.array.setByte(0L, 0, (byte)123);
        this.array.setShort(0L, 1, (short)1234);
        this.array.setInt(0L, 5, 12345);
        this.array.setLong(0L, 9, 9223372036854775707L);
        this.array.set3ByteInt(0L, 17, 76767);
        Assert.assertEquals((long)123L, (long)this.array.getByte(0L, 0));
        Assert.assertEquals((long)1234L, (long)this.array.getShort(0L, 1));
        Assert.assertEquals((long)12345L, (long)this.array.getInt(0L, 5));
        Assert.assertEquals((long)9223372036854775707L, (long)this.array.getLong(0L, 9));
        Assert.assertEquals((long)76767L, (long)this.array.get3ByteInt(0L, 17));
    }

    @Test
    public void shouldDetectMinusOne() throws Exception {
        this.array.set6ByteLong(10L, 2, -1L);
        this.array.set6ByteLong(10L, 8, -1L);
        Assert.assertEquals((long)-1L, (long)this.array.get6ByteLong(10L, 2));
        Assert.assertEquals((long)-1L, (long)this.array.get6ByteLong(10L, 8));
    }
}

