/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.SimpleInputIteratorWrapper;

public class UtilsTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void shouldDetectCollisions() throws Exception {
        long[] first = new long[]{1L, 4L, 7L, 10L, 100L, 101L};
        long[] other = new long[]{2L, 3L, 34L, 75L, 101L};
        boolean collides = Utils.anyIdCollides((long[])first, (int)first.length, (long[])other, (int)other.length);
        Assert.assertTrue((boolean)collides);
    }

    @Test
    public void failSafeCastLongToIntOnOverflow() {
        this.expectedException.expect(ArithmeticException.class);
        this.expectedException.expectMessage("Value 2147483648 is too big to be represented as int");
        Utils.safeCastLongToInt((long)0x80000000L);
    }

    @Test
    public void failSafeCastLongToShortOnOverflow() {
        this.expectedException.expect(ArithmeticException.class);
        this.expectedException.expectMessage("Value 32768 is too big to be represented as short");
        Utils.safeCastLongToShort((long)32768L);
    }

    @Test
    public void shouldNotReportDisjointArraysAsCollision() throws Exception {
        long[] first = new long[]{1L, 4L, 7L, 10L, 100L, 101L};
        long[] other = new long[]{2L, 3L, 34L, 75L, 102L};
        boolean collides = Utils.anyIdCollides((long[])first, (int)first.length, (long[])other, (int)other.length);
        Assert.assertFalse((boolean)collides);
    }

    @Test
    public void shouldBeCorrectForSomeRandomBatches() throws Exception {
        int i;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long[][] batches = new long[20][];
        for (i = 0; i < batches.length; ++i) {
            batches[i] = this.randomBatch(1000, random, 5000000);
        }
        for (i = 0; i < batches.length; ++i) {
            for (int j = 0; j < batches.length; ++j) {
                Assert.assertEquals((Object)this.actuallyCollides(batches[i], batches[j]), (Object)Utils.anyIdCollides((long[])batches[i], (int)batches[i].length, (long[])batches[j], (int)batches[j].length));
            }
        }
    }

    @Test
    public void shouldMergeIdsInto() throws Exception {
        long[] values = new long[]{2L, 4L, 10L, 11L, 14L};
        long[] into = new long[]{1L, 5L, 6L, 11L, 25L};
        int intoLengthBefore = into.length;
        into = Arrays.copyOf(into, into.length + values.length);
        Utils.mergeSortedInto((long[])values, (long[])into, (int)intoLengthBefore);
        Assert.assertArrayEquals((long[])new long[]{1L, 2L, 4L, 5L, 6L, 10L, 11L, 11L, 14L, 25L}, (long[])into);
    }

    @Test
    public void shouldMergeSomeRandomIdsInto() throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int batchSize = 10000;
        for (int i = 0; i < 100; ++i) {
            long[] values = this.randomBatch(batchSize, random, 100000000);
            long[] into = this.randomBatch(batchSize, random, 100000000);
            long[] expectedMergedArray = this.manuallyMerge(values, into);
            into = Arrays.copyOf(into, batchSize * 2);
            Utils.mergeSortedInto((long[])values, (long[])into, (int)batchSize);
            Assert.assertArrayEquals((long[])expectedMergedArray, (long[])into);
        }
    }

    @Test
    public void shouldContinueIdIteratorThroughNulls() throws Exception {
        List<InputNode> inputs = Arrays.asList(new InputNode("Source", 1L, 1L, (Object)"1", InputEntity.NO_PROPERTIES, null, InputEntity.NO_LABELS, null), new InputNode("Source", 2L, 2L, null, InputEntity.NO_PROPERTIES, null, InputEntity.NO_LABELS, null), new InputNode("Source", 3L, 3L, (Object)"3", InputEntity.NO_PROPERTIES, null, InputEntity.NO_LABELS, null));
        InputIterable<InputNode> input = SimpleInputIteratorWrapper.wrap("Source", inputs);
        InputIterator ids = Utils.idsOf(input).iterator();
        Assert.assertEquals((Object)"1", ids.next());
        Assert.assertNull(ids.next());
        Assert.assertEquals((Object)"3", ids.next());
        Assert.assertFalse((boolean)ids.hasNext());
    }

    private long[] manuallyMerge(long[] values, long[] into) {
        long[] all = new long[values.length + into.length];
        System.arraycopy(values, 0, all, 0, values.length);
        System.arraycopy(into, 0, all, values.length, into.length);
        Arrays.sort(all);
        return all;
    }

    private boolean actuallyCollides(long[] b1, long[] b2) {
        for (int i = 0; i < b1.length; ++i) {
            for (int j = 0; j < b2.length; ++j) {
                if (b1[i] != b2[j]) continue;
                return true;
            }
        }
        return false;
    }

    private long[] randomBatch(int length, Random random, int max) {
        long[] result = new long[length];
        this.randomBatchInto(result, length, random, max);
        return result;
    }

    private void randomBatchInto(long[] into, int length, Random random, int max) {
        for (int i = 0; i < length; ++i) {
            into[i] = random.nextInt(max);
        }
        Arrays.sort(into, 0, length);
    }
}

