/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.unsafe.impl.batchimport.EncodeGroupsStep;
import org.neo4j.unsafe.impl.batchimport.ReadGroupsFromCacheStepTest;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class EncodeGroupsStepTest {
    @Test
    public void shouldEncodeGroupChains() throws Throwable {
        StageControl control = (StageControl)Mockito.mock(StageControl.class);
        AtomicLong nextId = new AtomicLong();
        RecordStore store = (RecordStore)Mockito.mock(RecordStore.class);
        Mockito.when((Object)store.nextId()).thenAnswer(invocation -> nextId.incrementAndGet());
        ((RecordStore)Mockito.doAnswer(invocation -> {
            ((RelationshipGroupRecord)invocation.getArgumentAt(0, RelationshipGroupRecord.class)).setFirstOut(1L);
            return null;
        }).when((Object)store)).prepareForCommit((AbstractBaseRecord)Matchers.any(RelationshipGroupRecord.class));
        org.neo4j.unsafe.impl.batchimport.Configuration config = org.neo4j.unsafe.impl.batchimport.Configuration.withBatchSize((org.neo4j.unsafe.impl.batchimport.Configuration)org.neo4j.unsafe.impl.batchimport.Configuration.DEFAULT, (int)10);
        EncodeGroupsStep encoder = new EncodeGroupsStep(control, (Configuration)config, store);
        encoder.start(1);
        Catcher catcher = new Catcher();
        encoder.process(this.batch(new ReadGroupsFromCacheStepTest.Group(1L, 3), new ReadGroupsFromCacheStepTest.Group(2L, 3), new ReadGroupsFromCacheStepTest.Group(3L, 4)), (BatchSender)catcher);
        encoder.process(this.batch(new ReadGroupsFromCacheStepTest.Group(4L, 2), new ReadGroupsFromCacheStepTest.Group(5L, 10)), (BatchSender)catcher);
        encoder.process(this.batch(new ReadGroupsFromCacheStepTest.Group(6L, 35)), (BatchSender)catcher);
        encoder.process(this.batch(new ReadGroupsFromCacheStepTest.Group(7L, 2)), (BatchSender)catcher);
        encoder.endOfUpstream();
        while (!encoder.isCompleted()) {
            Thread.sleep(10L);
        }
        encoder.close();
        Assert.assertEquals((long)4L, (long)catcher.batches.size());
        long lastOwningNodeLastBatch = -1L;
        for (RelationshipGroupRecord[] batch : catcher.batches) {
            this.assertBatch(batch, lastOwningNodeLastBatch);
            lastOwningNodeLastBatch = batch[batch.length - 1].getOwningNode();
        }
    }

    private void assertBatch(RelationshipGroupRecord[] batch, long lastOwningNodeLastBatch) {
        for (int i = 0; i < batch.length; ++i) {
            RelationshipGroupRecord record = batch[i];
            Assert.assertTrue((record.getId() > Record.NULL_REFERENCE.longValue() ? 1 : 0) != 0);
            Assert.assertTrue((record.getOwningNode() > lastOwningNodeLastBatch ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)record.getFirstOut());
            if (record.getNext() != Record.NULL_REFERENCE.longValue()) continue;
            Assert.assertTrue((i == batch.length - 1 || batch[i + 1].getOwningNode() > record.getOwningNode() ? 1 : 0) != 0);
        }
    }

    private RelationshipGroupRecord[] batch(ReadGroupsFromCacheStepTest.Group ... groups) {
        return ReadGroupsFromCacheStepTest.groups(groups).toArray(new RelationshipGroupRecord[0]);
    }

    private static class Catcher
    implements BatchSender {
        private final List<RelationshipGroupRecord[]> batches = new ArrayList<RelationshipGroupRecord[]>();

        private Catcher() {
        }

        public void send(Object batch) {
            this.batches.add((RelationshipGroupRecord[])batch);
        }
    }
}

