/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.helpers.ConcurrentTransfer;
import org.neo4j.test.Barrier;
import org.neo4j.test.ReflectionUtil;

public class ThreadingRule
extends ExternalResource {
    private ExecutorService executor;

    protected void before() throws Throwable {
        this.executor = Executors.newCachedThreadPool();
    }

    protected void after() {
        try {
            this.executor.shutdownNow();
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.executor = null;
        }
    }

    public <FROM, TO, EX extends Exception> Future<TO> execute(ThrowingFunction<FROM, TO, EX> function, FROM parameter) {
        return this.executor.submit(ThreadingRule.task(Barrier.NONE, function, parameter, t -> {}));
    }

    public <FROM, TO, EX extends Exception> Future<TO> executeAndAwait(ThrowingFunction<FROM, TO, EX> function, FROM parameter, Predicate<Thread> threadCondition, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        ConcurrentTransfer threadTransfer = new ConcurrentTransfer();
        Future<TO> future = this.executor.submit(ThreadingRule.task(Barrier.NONE, function, parameter, (Consumer<Thread>)threadTransfer));
        Predicates.await((Supplier)threadTransfer, threadCondition, (long)timeout, (TimeUnit)unit);
        return future;
    }

    private static <FROM, TO, EX extends Exception> Callable<TO> task(Barrier barrier, ThrowingFunction<FROM, TO, EX> function, FROM parameter, Consumer<Thread> threadConsumer) {
        return () -> {
            Thread thread = Thread.currentThread();
            String name = thread.getName();
            thread.setName(function.toString());
            threadConsumer.accept(thread);
            barrier.reached();
            try {
                Object object = function.apply(parameter);
                return object;
            }
            finally {
                thread.setName(name);
            }
        };
    }

    public static Predicate<Thread> waitingWhileIn(final Class<?> owner, final String method) {
        return new Predicate<Thread>(){

            @Override
            public boolean test(Thread thread) {
                ReflectionUtil.verifyMethodExists(owner, method);
                if (thread.getState() != Thread.State.WAITING && thread.getState() != Thread.State.TIMED_WAITING) {
                    return false;
                }
                for (StackTraceElement element : thread.getStackTrace()) {
                    if (!element.getClassName().equals(owner.getName()) || !element.getMethodName().equals(method)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return String.format("Predicate[Thread.state=WAITING && thread.getStackTrace() contains %s.%s()]", owner.getName(), method);
            }
        };
    }
}

