/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.ResourceRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public final class Resources
implements TestRule {
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final ResourceRule<PageCache> pageCache = ResourceRule.pageCache(this.fs);
    private final ResourceRule<File> testPath;
    private final LifeRule life = new LifeRule();

    public Resources(TestPath path) {
        if (path != null) {
            switch (path) {
                case EXISTING_DIRECTORY: {
                    this.testPath = ResourceRule.existingDirectory(this.fs);
                    return;
                }
                case FILE_IN_EXISTING_DIRECTORY: {
                    this.testPath = ResourceRule.fileInExistingDirectory(this.fs);
                    return;
                }
            }
            throw new IllegalArgumentException("Unknown path: " + (Object)((Object)path));
        }
        this.testPath = ResourceRule.testPath();
    }

    public Statement apply(Statement base, Description description) {
        return this.fs.apply(this.testPath.apply(this.pageCache.apply(this.lifeStatement(base, description), description), description), description);
    }

    private Statement lifeStatement(Statement base, Description description) {
        Life initialLifecycle = (Life)description.getAnnotation(Life.class);
        if (initialLifecycle != null) {
            base = this.initialise(base, initialLifecycle.value());
        }
        return this.life.apply(base, description);
    }

    private Statement initialise(final Statement base, final InitialLifecycle initialLifecycle) {
        return new Statement(){

            public void evaluate() throws Throwable {
                initialLifecycle.initialize(Resources.this.life);
                base.evaluate();
            }
        };
    }

    public FileSystemAbstraction fileSystem() {
        return this.fs.get();
    }

    public PageCache pageCache() {
        return this.pageCache.get();
    }

    public File testPath() {
        return this.testPath.get();
    }

    public void lifeInitialises() throws LifecycleException {
        this.life.init();
    }

    public void lifeStarts() throws LifecycleException {
        this.life.start();
    }

    public void lifeStops() throws LifecycleException {
        this.life.stop();
    }

    public void lifeShutsDown() throws LifecycleException {
        this.life.shutdown();
    }

    public <T> T managed(T service) {
        Object lifecycle = null;
        if (service instanceof Lifecycle) {
            lifecycle = (Lifecycle)service;
        } else if (service instanceof AutoCloseable) {
            lifecycle = new Closer((AutoCloseable)service);
        }
        this.life.add(lifecycle);
        return service;
    }

    public LogProvider logProvider() {
        return NullLogProvider.getInstance();
    }

    private static class Closer
    extends LifecycleAdapter {
        private final AutoCloseable closeable;

        Closer(AutoCloseable closeable) {
            this.closeable = closeable;
        }

        public void shutdown() throws Exception {
            this.closeable.close();
        }
    }

    public static enum TestPath {
        EXISTING_DIRECTORY,
        FILE_IN_EXISTING_DIRECTORY;

    }

    public static enum InitialLifecycle {
        INITIALIZED{

            @Override
            void initialize(LifeRule life) {
                life.init();
            }
        }
        ,
        STARTED{

            @Override
            void initialize(LifeRule life) {
                life.start();
            }
        };


        abstract void initialize(LifeRule var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Life {
        public InitialLifecycle value();
    }
}

