/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class OnDemandJobScheduler
extends LifecycleAdapter
implements JobScheduler {
    private Runnable job;

    public Executor executor(JobScheduler.Group group) {
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                OnDemandJobScheduler.this.job = command;
            }
        };
    }

    public ThreadFactory threadFactory(JobScheduler.Group group) {
        throw new UnsupportedOperationException();
    }

    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job) {
        return this.schedule(group, job, JobScheduler.Group.NO_METADATA);
    }

    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job, Map<String, String> metadata) {
        this.job = job;
        return new OnDemandJobHandle();
    }

    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job, long initialDelay, TimeUnit timeUnit) {
        this.job = job;
        return new OnDemandJobHandle();
    }

    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        this.job = runnable;
        return new OnDemandJobHandle();
    }

    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        this.job = runnable;
        return new OnDemandJobHandle();
    }

    public Runnable getJob() {
        return this.job;
    }

    public void runJob() {
        if (this.job != null) {
            this.job.run();
        }
    }

    private class OnDemandJobHandle
    implements JobScheduler.JobHandle {
        private OnDemandJobHandle() {
        }

        public void cancel(boolean mayInterruptIfRunning) {
            OnDemandJobScheduler.this.job = null;
        }

        public void waitTermination() throws InterruptedException, ExecutionException {
        }
    }
}

