/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.util.Map;
import org.neo4j.graphdb.mockfs.LimitedFilesystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.test.ImpermanentGraphDatabase;

public class LimitedFileSystemGraphDatabase
extends ImpermanentGraphDatabase {
    private LimitedFilesystemAbstraction fs;

    public LimitedFileSystemGraphDatabase(File storeDir) {
        super(storeDir);
    }

    @Override
    protected void create(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, CommunityEditionModule::new){

            protected PlatformModule createPlatform(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade facade) {
                return new ImpermanentGraphDatabase.ImpermanentPlatformModule(storeDir, params, this.databaseInfo, dependencies, facade){

                    @Override
                    protected FileSystemAbstraction createFileSystemAbstraction() {
                        return LimitedFileSystemGraphDatabase.this.fs = new LimitedFilesystemAbstraction(super.createFileSystemAbstraction());
                    }
                };
            }
        }.initFacade(storeDir, params, dependencies, (GraphDatabaseFacade)this);
    }

    public void runOutOfDiskSpaceNao() {
        this.fs.runOutOfDiskSpace(true);
    }

    public void somehowGainMoreDiskSpace() {
        this.fs.runOutOfDiskSpace(false);
    }

    public LimitedFilesystemAbstraction getFileSystem() {
        return this.fs;
    }
}

