/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.NullLogProvider;

public class DatabaseHealthTest {
    @Test
    public void shouldGenerateKernelPanicEvents() throws Exception {
        DatabasePanicEventGenerator generator = (DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class);
        DatabaseHealth databaseHealth = new DatabaseHealth(generator, NullLogProvider.getInstance().getLog(DatabaseHealth.class));
        databaseHealth.healed();
        Exception cause = new Exception("My own fault");
        databaseHealth.panic((Throwable)cause);
        databaseHealth.panic((Throwable)cause);
        ((DatabasePanicEventGenerator)Mockito.verify((Object)generator, (VerificationMode)Mockito.times((int)1))).generateEvent(ErrorState.TX_MANAGER_NOT_OK, (Throwable)cause);
    }

    @Test
    public void shouldLogKernelPanicEvent() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        DatabaseHealth databaseHealth = new DatabaseHealth((DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), logProvider.getLog(DatabaseHealth.class));
        databaseHealth.healed();
        String message = "Listen everybody... panic!";
        Exception exception = new Exception(message);
        databaseHealth.panic((Throwable)exception);
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(DatabaseHealth.class).error(Is.is((Object)"Database panic: Database has encountered some problem, please perform necessary action (tx recovery/restart)"), Matchers.sameInstance((Object)exception))});
    }
}

