/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.lang.reflect.Field;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.ArrayMap;

public class TestArrayMap {
    @Test
    public void testArrayMap() {
        int i;
        ArrayMap map = new ArrayMap();
        Assert.assertTrue((map.get((Object)"key1") == null ? 1 : 0) != 0);
        map.put((Object)"key1", (Object)0);
        Assert.assertEquals((Object)new Integer(0), (Object)map.get((Object)"key1"));
        Assert.assertEquals((Object)new Integer(0), (Object)map.get((Object)"key1"));
        map.put((Object)"key1", (Object)1);
        Assert.assertEquals((Object)new Integer(1), (Object)map.get((Object)"key1"));
        map.put((Object)"key2", (Object)0);
        Assert.assertEquals((Object)new Integer(0), (Object)map.get((Object)"key2"));
        map.put((Object)"key2", (Object)2);
        Assert.assertEquals((Object)new Integer(2), (Object)map.get((Object)"key2"));
        Assert.assertEquals((Object)new Integer(2), (Object)map.remove((Object)"key2"));
        Assert.assertTrue((map.get((Object)"key2") == null ? 1 : 0) != 0);
        Assert.assertEquals((Object)new Integer(1), (Object)map.get((Object)"key1"));
        Assert.assertEquals((Object)new Integer(1), (Object)map.remove((Object)"key1"));
        Assert.assertTrue((map.get((Object)"key1") == null ? 1 : 0) != 0);
        map.put((Object)"key1", (Object)1);
        map.put((Object)"key2", (Object)2);
        map.put((Object)"key3", (Object)3);
        map.put((Object)"key4", (Object)4);
        map.put((Object)"key5", (Object)5);
        Assert.assertEquals((Object)new Integer(5), (Object)map.get((Object)"key5"));
        Assert.assertEquals((Object)new Integer(4), (Object)map.get((Object)"key4"));
        Assert.assertEquals((Object)new Integer(3), (Object)map.get((Object)"key3"));
        Assert.assertEquals((Object)new Integer(2), (Object)map.get((Object)"key2"));
        Assert.assertEquals((Object)new Integer(1), (Object)map.get((Object)"key1"));
        Assert.assertEquals((Object)new Integer(5), (Object)map.remove((Object)"key5"));
        Assert.assertEquals((Object)new Integer(1), (Object)map.get((Object)"key1"));
        Assert.assertEquals((Object)new Integer(4), (Object)map.get((Object)"key4"));
        Assert.assertEquals((Object)new Integer(3), (Object)map.get((Object)"key3"));
        Assert.assertEquals((Object)new Integer(2), (Object)map.get((Object)"key2"));
        Assert.assertEquals((Object)new Integer(3), (Object)map.remove((Object)"key3"));
        Assert.assertEquals((Object)new Integer(1), (Object)map.remove((Object)"key1"));
        Assert.assertEquals((Object)new Integer(2), (Object)map.remove((Object)"key2"));
        for (i = 0; i < 100; ++i) {
            map.put((Object)("key" + i), (Object)i);
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)new Integer(i), (Object)map.get((Object)("key" + i)));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)new Integer(i), (Object)map.remove((Object)("key" + i)));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((map.get((Object)("key" + i)) == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void arraymapIsClearedWhenExpandingToHashMapIfNonShrinkable() throws Exception {
        this.assertDataRepresentationSwitchesWhenAboveThreshold((ArrayMap<String, Integer>)new ArrayMap(3, false, false), false);
    }

    @Test
    public void arraymapIsClearedWhenExpandingToHashMapIfShrinkable() throws Exception {
        this.assertDataRepresentationSwitchesWhenAboveThreshold((ArrayMap<String, Integer>)new ArrayMap(3, false, true), true);
    }

    @Test
    public void arraymapIsClearedWhenExpandingToHashMapIfNonShrinkableAndSynchronized() throws Exception {
        this.assertDataRepresentationSwitchesWhenAboveThreshold((ArrayMap<String, Integer>)new ArrayMap(3, true, false), false);
    }

    @Test
    public void arraymapIsClearedWhenExpandingToHashMapIfShrinkableAndSynchronized() throws Exception {
        this.assertDataRepresentationSwitchesWhenAboveThreshold((ArrayMap<String, Integer>)new ArrayMap(3, true, true), true);
    }

    private void assertDataRepresentationSwitchesWhenAboveThreshold(ArrayMap<String, Integer> map, boolean shrinkable) throws Exception {
        Field mapThresholdField = ArrayMap.class.getDeclaredField("toMapThreshold");
        mapThresholdField.setAccessible(true);
        int arraySize = mapThresholdField.getInt(map);
        Field dataField = ArrayMap.class.getDeclaredField("data");
        dataField.setAccessible(true);
        Assert.assertTrue((boolean)(dataField.get(map) instanceof Object[]));
        for (int i = 0; i < arraySize; ++i) {
            map.put((Object)("key" + i), (Object)i);
            Assert.assertTrue((boolean)(dataField.get(map) instanceof Object[]));
        }
        map.put((Object)"next key", (Object)999);
        Map dataAsMap = (Map)dataField.get(map);
        Assert.assertEquals((long)(arraySize + 1), (long)dataAsMap.size());
        map.remove((Object)"key1");
        map.remove((Object)"key2");
        map.remove((Object)"key3");
        if (shrinkable) {
            Assert.assertTrue((boolean)(dataField.get(map) instanceof Object[]));
        } else {
            Assert.assertTrue((boolean)(dataField.get(map) instanceof Map));
        }
    }

    @Test
    public void canOverwriteThenRemoveElementAcrossDeflation() throws Exception {
        ArrayMap map = new ArrayMap(3, false, true);
        map.put((Object)"key1", (Object)1);
        map.put((Object)"key2", (Object)2);
        map.put((Object)"key3", (Object)3);
        map.put((Object)"key4", (Object)4);
        map.put((Object)"key5", (Object)5);
        map.put((Object)"key1", (Object)6);
        map.remove((Object)"key1");
        Assert.assertNull((String)"removed element still found", (Object)map.get((Object)"key1"));
        map.remove((Object)"key2");
        Assert.assertNull((String)"removed element still found", (Object)map.get((Object)"key1"));
        map.remove((Object)"key3");
        Assert.assertNull((String)"removed element still found", (Object)map.get((Object)"key1"));
        map.remove((Object)"key4");
        Assert.assertNull((String)"removed element still found", (Object)map.get((Object)"key1"));
    }
}

