/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.test.rule.TestDirectory;

public class FileUtilsTest {
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    public ExpectedException expected = ExpectedException.none();
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.expected);
    private File path;

    @Before
    public void doBefore() throws Exception {
        this.path = this.testDirectory.directory("path");
    }

    @Test
    public void moveFileToDirectory() throws Exception {
        File file = this.touchFile("source");
        File targetDir = this.directory("dir");
        File newLocationOfFile = FileUtils.moveFileToDirectory((File)file, (File)targetDir);
        Assert.assertTrue((boolean)newLocationOfFile.exists());
        Assert.assertFalse((boolean)file.exists());
        Assert.assertEquals((Object)newLocationOfFile, (Object)targetDir.listFiles()[0]);
    }

    @Test
    public void moveFile() throws Exception {
        File file = this.touchFile("source");
        File targetDir = this.directory("dir");
        File newLocationOfFile = new File(targetDir, "new-name");
        FileUtils.moveFile((File)file, (File)newLocationOfFile);
        Assert.assertTrue((boolean)newLocationOfFile.exists());
        Assert.assertFalse((boolean)file.exists());
        Assert.assertEquals((Object)newLocationOfFile, (Object)targetDir.listFiles()[0]);
    }

    @Test
    public void testEmptyDirectory() throws IOException {
        File emptyDir = this.directory("emptyDir");
        File nonEmptyDir = this.directory("nonEmptyDir");
        File directoryContent = new File(nonEmptyDir, "somefile");
        assert (directoryContent.createNewFile());
        Assert.assertTrue((boolean)FileUtils.isEmptyDirectory((File)emptyDir));
        Assert.assertFalse((boolean)FileUtils.isEmptyDirectory((File)nonEmptyDir));
    }

    @Test
    public void pathToFileAfterMoveMustThrowIfFileNotSubPathToFromShorter() throws Exception {
        File file = new File("/a");
        File from = new File("/a/b");
        File to = new File("/a/c");
        this.expected.expect(IllegalArgumentException.class);
        FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file);
    }

    @Test
    public void pathToFileAfterMoveMustThrowIfFileNotSubPathToFromSameLength() throws Exception {
        File file = new File("/a/f");
        File from = new File("/a/b");
        File to = new File("/a/c");
        this.expected.expect(IllegalArgumentException.class);
        FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file);
    }

    @Test
    public void pathToFileAfterMoveMustThrowIfFileNotSubPathToFromLonger() throws Exception {
        File file = new File("/a/c/f");
        File from = new File("/a/b");
        File to = new File("/a/c");
        this.expected.expect(IllegalArgumentException.class);
        FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file);
    }

    @Test
    public void pathToFileAfterMoveMustThrowIfFromDirIsCompletePathToFile() throws Exception {
        File file = new File("/a/b/f");
        File from = new File("/a/b/f");
        File to = new File("/a/c");
        this.expected.expect(IllegalArgumentException.class);
        FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file);
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfMovingToSibling() throws Exception {
        File file = new File("/a/b/f");
        File from = new File("/a/b");
        File to = new File("/a/c");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/a/c/f")));
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfMovingToSiblingAndFileHasSubDir() throws Exception {
        File file = new File("/a/b/d/f");
        File from = new File("/a/b");
        File to = new File("/a/c");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/a/c/d/f")));
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfMovingToSubDir() throws Exception {
        File file = new File("/a/b/f");
        File from = new File("/a/b");
        File to = new File("/a/b/c");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/a/b/c/f")));
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfMovingToSubDirAndFileHasSubDir() throws Exception {
        File file = new File("/a/b/d/f");
        File from = new File("/a/b");
        File to = new File("/a/b/c");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/a/b/c/d/f")));
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfMovingOutOfDir() throws Exception {
        File file = new File("/a/b/f");
        File from = new File("/a/b");
        File to = new File("/c");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/c/f")));
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfMovingOutOfDirAndFileHasSubDir() throws Exception {
        File file = new File("/a/b/d/f");
        File from = new File("/a/b");
        File to = new File("/c");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/c/d/f")));
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfNotMovingAtAll() throws Exception {
        File file = new File("/a/b/f");
        File from = new File("/a/b");
        File to = new File("/a/b");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/a/b/f")));
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfNotMovingAtAllAndFileHasSubDir() throws Exception {
        File file = new File("/a/b/d/f");
        File from = new File("/a/b");
        File to = new File("/a/b");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/a/b/d/f")));
    }

    private File directory(String name) {
        File dir = new File(this.path, name);
        dir.mkdirs();
        return dir;
    }

    private File touchFile(String name) throws IOException {
        File file = new File(this.path, name);
        file.createNewFile();
        return file;
    }

    private String path(String path) {
        return new File(path).getPath();
    }
}

