/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Arrays;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.AbstractSchemaRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.RecordSerializable;
import org.neo4j.kernel.impl.store.record.RecordSerializer;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.store.record.UniquePropertyConstraintRule;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandHandlerContract;
import org.neo4j.kernel.impl.transaction.command.IndexBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.IndexUpdatesWork;
import org.neo4j.kernel.impl.transaction.command.LabelUpdateWork;
import org.neo4j.kernel.impl.transaction.command.NeoStoreBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_2;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaRuleCommandTest {
    private final int labelId = 2;
    private final int propertyKey = 8;
    private final long id = 0L;
    private final long txId = 1337L;
    private final NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
    private final MetaDataStore metaDataStore = (MetaDataStore)Mockito.mock(MetaDataStore.class);
    private final SchemaStore schemaStore = (SchemaStore)Mockito.mock(SchemaStore.class);
    private final IndexingService indexes = (IndexingService)Mockito.mock(IndexingService.class);
    private final Supplier<LabelScanWriter> labelScanStore = (Supplier)Mockito.mock(Supplier.class);
    private final NeoStoreBatchTransactionApplier storeApplier = new NeoStoreBatchTransactionApplier(this.neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
    private final WorkSync<Supplier<LabelScanWriter>, LabelUpdateWork> labelScanStoreSynchronizer = new WorkSync(this.labelScanStore);
    private final WorkSync<IndexingService, IndexUpdatesWork> indexUpdatesSync = new WorkSync((Object)this.indexes);
    private final PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);
    private final IndexBatchTransactionApplier indexApplier = new IndexBatchTransactionApplier(this.indexes, this.labelScanStoreSynchronizer, this.indexUpdatesSync, (NodeStore)Mockito.mock(NodeStore.class), (PropertyLoader)Mockito.mock(PropertyLoader.class), new PropertyPhysicalToLogicalConverter(this.propertyStore), TransactionApplicationMode.INTERNAL);
    private final PhysicalLogCommandReaderV2_2 reader = new PhysicalLogCommandReaderV2_2();
    private final IndexRule rule = IndexRule.indexRule((long)0L, (int)2, (int)8, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);

    @Test
    public void shouldWriteCreatedSchemaRuleToStore() throws Exception {
        SchemaRecord beforeRecords = this.serialize((AbstractSchemaRule)this.rule, 0L, false, false);
        SchemaRecord afterRecords = this.serialize((AbstractSchemaRule)this.rule, 0L, true, true);
        Mockito.when((Object)this.neoStores.getSchemaStore()).thenReturn((Object)this.schemaStore);
        this.visitSchemaRuleCommand((BatchTransactionApplier)this.storeApplier, new Command.SchemaRuleCommand(beforeRecords, afterRecords, (SchemaRule)this.rule));
        ((SchemaStore)Mockito.verify((Object)this.schemaStore)).updateRecord((AbstractBaseRecord)Iterables.first((Iterable)afterRecords));
    }

    @Test
    public void shouldCreateIndexForCreatedSchemaRule() throws Exception {
        SchemaRecord beforeRecords = this.serialize((AbstractSchemaRule)this.rule, 0L, false, false);
        SchemaRecord afterRecords = this.serialize((AbstractSchemaRule)this.rule, 0L, true, true);
        Mockito.when((Object)this.neoStores.getSchemaStore()).thenReturn((Object)this.schemaStore);
        this.visitSchemaRuleCommand((BatchTransactionApplier)this.indexApplier, new Command.SchemaRuleCommand(beforeRecords, afterRecords, (SchemaRule)this.rule));
        ((IndexingService)Mockito.verify((Object)this.indexes)).createIndexes(new IndexRule[]{this.rule});
    }

    @Test
    public void shouldSetLatestConstraintRule() throws Exception {
        SchemaRecord beforeRecords = this.serialize((AbstractSchemaRule)this.rule, 0L, true, true);
        SchemaRecord afterRecords = this.serialize((AbstractSchemaRule)this.rule, 0L, true, false);
        Mockito.when((Object)this.neoStores.getSchemaStore()).thenReturn((Object)this.schemaStore);
        Mockito.when((Object)this.neoStores.getMetaDataStore()).thenReturn((Object)this.metaDataStore);
        UniquePropertyConstraintRule schemaRule = UniquePropertyConstraintRule.uniquenessConstraintRule((long)0L, (int)2, (int)8, (long)0L);
        this.visitSchemaRuleCommand((BatchTransactionApplier)this.storeApplier, new Command.SchemaRuleCommand(beforeRecords, afterRecords, (SchemaRule)schemaRule));
        ((SchemaStore)Mockito.verify((Object)this.schemaStore)).updateRecord((AbstractBaseRecord)Iterables.first((Iterable)afterRecords));
        ((MetaDataStore)Mockito.verify((Object)this.metaDataStore)).setLatestConstraintIntroducingTx(1337L);
    }

    @Test
    public void shouldDropSchemaRuleFromStore() throws Exception {
        SchemaRecord beforeRecords = this.serialize((AbstractSchemaRule)this.rule, 0L, true, true);
        SchemaRecord afterRecords = this.serialize((AbstractSchemaRule)this.rule, 0L, false, false);
        Mockito.when((Object)this.neoStores.getSchemaStore()).thenReturn((Object)this.schemaStore);
        this.visitSchemaRuleCommand((BatchTransactionApplier)this.storeApplier, new Command.SchemaRuleCommand(beforeRecords, afterRecords, (SchemaRule)this.rule));
        ((SchemaStore)Mockito.verify((Object)this.schemaStore)).updateRecord((AbstractBaseRecord)Iterables.first((Iterable)afterRecords));
    }

    @Test
    public void shouldDropSchemaRuleFromIndex() throws Exception {
        SchemaRecord beforeRecords = this.serialize((AbstractSchemaRule)this.rule, 0L, true, true);
        SchemaRecord afterRecords = this.serialize((AbstractSchemaRule)this.rule, 0L, false, false);
        Mockito.when((Object)this.neoStores.getSchemaStore()).thenReturn((Object)this.schemaStore);
        this.visitSchemaRuleCommand((BatchTransactionApplier)this.indexApplier, new Command.SchemaRuleCommand(beforeRecords, afterRecords, (SchemaRule)this.rule));
        ((IndexingService)Mockito.verify((Object)this.indexes)).dropIndex(this.rule);
    }

    @Test
    public void shouldWriteSchemaRuleToLog() throws Exception {
        SchemaRecord beforeRecords = this.serialize((AbstractSchemaRule)this.rule, 0L, false, false);
        SchemaRecord afterRecords = this.serialize((AbstractSchemaRule)this.rule, 0L, true, true);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(beforeRecords, afterRecords, (SchemaRule)this.rule);
        InMemoryClosableChannel buffer = new InMemoryClosableChannel();
        Mockito.when((Object)this.neoStores.getSchemaStore()).thenReturn((Object)this.schemaStore);
        command.serialize((WritableChannel)buffer);
        Command readCommand = this.reader.read((ReadableChannel)buffer);
        Assert.assertThat((Object)readCommand, (Matcher)CoreMatchers.instanceOf(Command.SchemaRuleCommand.class));
        this.assertSchemaRule((Command.SchemaRuleCommand)readCommand);
    }

    @Test
    public void shouldRecreateSchemaRuleWhenDeleteCommandReadFromDisk() throws Exception {
        SchemaRecord beforeRecords = this.serialize((AbstractSchemaRule)this.rule, 0L, true, true);
        SchemaRecord afterRecords = this.serialize((AbstractSchemaRule)this.rule, 0L, false, false);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(beforeRecords, afterRecords, (SchemaRule)this.rule);
        InMemoryClosableChannel buffer = new InMemoryClosableChannel();
        Mockito.when((Object)this.neoStores.getSchemaStore()).thenReturn((Object)this.schemaStore);
        command.serialize((WritableChannel)buffer);
        Command readCommand = this.reader.read((ReadableChannel)buffer);
        Assert.assertThat((Object)readCommand, (Matcher)CoreMatchers.instanceOf(Command.SchemaRuleCommand.class));
        this.assertSchemaRule((Command.SchemaRuleCommand)readCommand);
    }

    private SchemaRecord serialize(AbstractSchemaRule rule, long id, boolean inUse, boolean created) {
        RecordSerializer serializer = new RecordSerializer();
        serializer = serializer.append((RecordSerializable)rule);
        DynamicRecord record = new DynamicRecord(id);
        record.setData(serializer.serialize());
        if (created) {
            record.setCreated();
        }
        if (inUse) {
            record.setInUse(true);
        }
        return new SchemaRecord(Arrays.asList(record));
    }

    private void assertSchemaRule(Command.SchemaRuleCommand readSchemaCommand) {
        Assert.assertEquals((long)0L, (long)readSchemaCommand.getKey());
        Assert.assertEquals((long)2L, (long)readSchemaCommand.getSchemaRule().getLabel());
        Assert.assertEquals((long)8L, (long)((IndexRule)readSchemaCommand.getSchemaRule()).getPropertyKey());
    }

    private void visitSchemaRuleCommand(BatchTransactionApplier applier, Command.SchemaRuleCommand command) throws Exception {
        TransactionToApply tx = new TransactionToApply((TransactionRepresentation)new PhysicalTransactionRepresentation(Arrays.asList(command)), 1337L);
        CommandHandlerContract.apply(applier, tx);
    }
}

