/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.transaction.log.checkpoint.DefaultCheckPointerTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.test.OnDemandJobScheduler;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

public class DefaultCheckPointerTracerTest {
    private final FakeClock clock = Clocks.fakeClock();
    private final DefaultCheckPointerTracer.Monitor monitor = (DefaultCheckPointerTracer.Monitor)Mockito.mock(DefaultCheckPointerTracer.Monitor.class);
    private final OnDemandJobScheduler jobScheduler = new OnDemandJobScheduler();

    @Test
    public void shouldCountEventsAnAccumulatedTotalTime() throws Throwable {
        DefaultCheckPointerTracer tracer = new DefaultCheckPointerTracer((SystemNanoClock)this.clock, this.monitor, (JobScheduler)this.jobScheduler);
        this.triggerEvent(tracer, 20);
        Assert.assertEquals((long)1L, (long)tracer.numberOfCheckPointEvents());
        Assert.assertEquals((long)20L, (long)tracer.checkPointAccumulatedTotalTimeMillis());
        ((DefaultCheckPointerTracer.Monitor)Mockito.verify((Object)this.monitor, (VerificationMode)Mockito.times((int)1))).lastCheckPointEventDuration(20L);
        this.triggerEvent(tracer, 30);
        Assert.assertEquals((long)2L, (long)tracer.numberOfCheckPointEvents());
        Assert.assertEquals((long)50L, (long)tracer.checkPointAccumulatedTotalTimeMillis());
        ((DefaultCheckPointerTracer.Monitor)Mockito.verify((Object)this.monitor, (VerificationMode)Mockito.times((int)1))).lastCheckPointEventDuration(30L);
    }

    @Test
    public void shouldReturnZeroIfNoDataIsAvailable() throws Throwable {
        DefaultCheckPointerTracer tracer = new DefaultCheckPointerTracer((SystemNanoClock)this.clock, this.monitor, (JobScheduler)this.jobScheduler);
        this.jobScheduler.runJob();
        Assert.assertEquals((long)0L, (long)tracer.numberOfCheckPointEvents());
        Assert.assertEquals((long)0L, (long)tracer.checkPointAccumulatedTotalTimeMillis());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.monitor});
    }

    private void triggerEvent(DefaultCheckPointerTracer tracer, int eventDuration) {
        this.clock.forward(ThreadLocalRandom.current().nextLong(200L), TimeUnit.MILLISECONDS);
        try (LogCheckPointEvent event = tracer.beginCheckPoint();){
            this.clock.forward((long)eventDuration, TimeUnit.MILLISECONDS);
        }
        this.jobScheduler.runJob();
    }
}

