/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.DeadSimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.storageengine.api.ReadPastEndException;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.concurrent.OtherThreadRule;

public class PhysicalLogFileRotateAndReadRaceIT {
    private final TestDirectory directory = TestDirectory.testDirectory(this.getClass());
    private final LifeRule life = new LifeRule(true);
    private final OtherThreadRule<Void> t2 = new OtherThreadRule(this.getClass().getName() + "-T2");
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.life).around(this.t2);
    private static final long LIMIT_TIME = TimeUnit.SECONDS.toMillis(5L);
    private static final int LIMIT_ROTATIONS = 500;
    private static final int LIMIT_READS = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotSeeEmptyLogFileWhenReadingTransactionStream() throws Exception {
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), (FileSystemAbstraction)fileSystem);
        DeadSimpleLogVersionRepository logVersionRepository = new DeadSimpleLogVersionRepository(0L);
        PhysicalLogFile.Monitor monitor = (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class);
        LogHeaderCache headerCache = new LogHeaderCache(10);
        PhysicalLogFile logFile = (PhysicalLogFile)this.life.add((Lifecycle)new PhysicalLogFile((FileSystemAbstraction)fileSystem, logFiles, ByteUnit.kibiBytes((long)1L), () -> 2L, (LogVersionRepository)logVersionRepository, monitor, headerCache));
        FlushablePositionAwareChannel writer = logFile.getWriter();
        LogPositionMarker startPosition = new LogPositionMarker();
        writer.getCurrentPosition(startPosition);
        AtomicBoolean end = new AtomicBoolean();
        byte[] dataChunk = new byte[100];
        AtomicInteger rotations = new AtomicInteger();
        CountDownLatch startSignal = new CountDownLatch(1);
        Future<Void> writeFuture = this.t2.execute(ignored -> {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            startSignal.countDown();
            while (!end.get()) {
                writer.put(dataChunk, random.nextInt(1, dataChunk.length));
                if (!logFile.rotationNeeded()) continue;
                logFile.rotate();
                writer.getCurrentPosition(startPosition);
                rotations.incrementAndGet();
            }
            return null;
        });
        Assert.assertTrue((boolean)startSignal.await(10L, TimeUnit.SECONDS));
        long maxEndTime = System.currentTimeMillis() + LIMIT_TIME;
        try {
            for (int reads = 0; System.currentTimeMillis() < maxEndTime && reads < 1000 && rotations.get() < 500; ++reads) {
                try (ReadableLogChannel reader = logFile.getReader(startPosition.newPosition());){
                    this.deplete(reader);
                    continue;
                }
            }
        }
        finally {
            end.set(true);
            writeFuture.get();
        }
    }

    private void deplete(ReadableLogChannel reader) {
        byte[] dataChunk = new byte[100];
        try {
            while (true) {
                reader.get(dataChunk, dataChunk.length);
            }
        }
        catch (ReadPastEndException readPastEndException) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

