/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;

public class TransactionMetadataCacheTest {
    @Test
    public void shouldReturnNullWhenMissingATxInTheCache() {
        TransactionMetadataCache cache = new TransactionMetadataCache(2);
        TransactionMetadataCache.TransactionMetadata metadata = cache.getTransactionMetadata(42L);
        Assert.assertNull((Object)metadata);
    }

    @Test
    public void shouldReturnTheTxValueTIfInTheCached() {
        TransactionMetadataCache cache = new TransactionMetadataCache(2);
        LogPosition position = new LogPosition(3L, 4L);
        int txId = 42;
        boolean masterId = false;
        boolean authorId = true;
        int checksum = 2;
        long timestamp = System.currentTimeMillis();
        cache.cacheTransactionMetadata(42L, position, 0, 1, 2L, timestamp);
        TransactionMetadataCache.TransactionMetadata metadata = cache.getTransactionMetadata(42L);
        Assert.assertEquals((Object)new TransactionMetadataCache.TransactionMetadata(0, 1, position, 2L, timestamp), (Object)metadata);
    }

    @Test
    public void shouldThrowWhenCachingATxWithNegativeOffsetPosition() {
        TransactionMetadataCache cache = new TransactionMetadataCache(2);
        LogPosition position = new LogPosition(3L, -1L);
        int txId = 42;
        boolean masterId = false;
        boolean authorId = true;
        int checksum = 2;
        long timestamp = System.currentTimeMillis();
        try {
            cache.cacheTransactionMetadata(42L, position, 0, 1, 2L, timestamp);
            Assert.fail();
        }
        catch (RuntimeException ex) {
            Assert.assertEquals((Object)("StartEntry.position is " + position), (Object)ex.getMessage());
        }
    }

    @Test
    public void shouldClearTheCache() {
        TransactionMetadataCache cache = new TransactionMetadataCache(2);
        LogPosition position = new LogPosition(3L, 4L);
        int txId = 42;
        boolean masterId = false;
        boolean authorId = true;
        int checksum = 2;
        long timestamp = System.currentTimeMillis();
        cache.cacheTransactionMetadata(42L, position, 0, 1, 2L, timestamp);
        cache.clear();
        TransactionMetadataCache.TransactionMetadata metadata = cache.getTransactionMetadata(42L);
        Assert.assertNull((Object)metadata);
    }
}

