/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.test.rule.TestDirectory;

public class ReadAheadLogChannelTest {
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();

    @Test
    public void shouldReadFromSingleChannel() throws Exception {
        File file = this.file(0);
        int byteValue = 5;
        int shortValue = 56;
        int intValue = 32145;
        long longValue = 5689456895869L;
        float floatValue = 12.12345f;
        double doubleValue = 3548.45748;
        final byte[] byteArrayValue = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.writeSomeData(file, new Visitor<ByteBuffer, IOException>(){

            public boolean visit(ByteBuffer element) throws IOException {
                element.put((byte)5);
                element.putShort((short)56);
                element.putInt(32145);
                element.putLong(5689456895869L);
                element.putFloat(12.12345f);
                element.putDouble(3548.45748);
                element.put(byteArrayValue);
                return true;
            }
        });
        StoreChannel storeChannel = this.fs.open(file, "r");
        PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel(storeChannel, -1L, -1);
        try (ReadAheadLogChannel channel = new ReadAheadLogChannel((LogVersionedStoreChannel)versionedStoreChannel, LogVersionBridge.NO_MORE_CHANNELS, 16);){
            Assert.assertEquals((long)5L, (long)channel.get());
            Assert.assertEquals((long)56L, (long)channel.getShort());
            Assert.assertEquals((long)32145L, (long)channel.getInt());
            Assert.assertEquals((long)5689456895869L, (long)channel.getLong());
            Assert.assertEquals((float)12.12345f, (float)channel.getFloat(), (float)0.1f);
            Assert.assertEquals((double)3548.45748, (double)channel.getDouble(), (double)0.1);
            byte[] bytes = new byte[byteArrayValue.length];
            channel.get(bytes, byteArrayValue.length);
            Assert.assertArrayEquals((byte[])byteArrayValue, (byte[])bytes);
        }
    }

    @Test
    public void shouldReadFromMultipleChannels() throws Exception {
        this.writeSomeData(this.file(0), new Visitor<ByteBuffer, IOException>(){

            public boolean visit(ByteBuffer element) throws IOException {
                for (int i = 0; i < 10; ++i) {
                    element.putLong(i);
                }
                return true;
            }
        });
        this.writeSomeData(this.file(1), new Visitor<ByteBuffer, IOException>(){

            public boolean visit(ByteBuffer element) throws IOException {
                for (int i = 10; i < 20; ++i) {
                    element.putLong(i);
                }
                return true;
            }
        });
        StoreChannel storeChannel = this.fs.open(this.file(0), "r");
        PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel(storeChannel, -1L, -1);
        try (ReadAheadLogChannel channel = new ReadAheadLogChannel((LogVersionedStoreChannel)versionedStoreChannel, new LogVersionBridge(){
            private boolean returned = false;

            public LogVersionedStoreChannel next(LogVersionedStoreChannel channel) throws IOException {
                if (!this.returned) {
                    this.returned = true;
                    channel.close();
                    return new PhysicalLogVersionedStoreChannel(ReadAheadLogChannelTest.this.fs.open(ReadAheadLogChannelTest.this.file(1), "r"), -1L, -1);
                }
                return channel;
            }
        }, 10);){
            for (long i = 0L; i < 20L; ++i) {
                Assert.assertEquals((long)i, (long)channel.getLong());
            }
        }
    }

    private void writeSomeData(File file, Visitor<ByteBuffer, IOException> visitor) throws IOException {
        try (StoreChannel channel = this.fs.open(file, "rw");){
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            visitor.visit((Object)buffer);
            buffer.flip();
            channel.write(buffer);
        }
    }

    private File file(int index) {
        return new File(this.directory.directory(), "" + index);
    }
}

