/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.function.IOFunction;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.kvstore.AbstractKeyValueStore;
import org.neo4j.kernel.impl.store.kvstore.ConcurrentMapState;
import org.neo4j.kernel.impl.store.kvstore.DataInitializer;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.EntryUpdater;
import org.neo4j.kernel.impl.store.kvstore.HeaderField;
import org.neo4j.kernel.impl.store.kvstore.Headers;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.PreparedRotation;
import org.neo4j.kernel.impl.store.kvstore.ProgressiveState;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.ReadableState;
import org.neo4j.kernel.impl.store.kvstore.Rotation;
import org.neo4j.kernel.impl.store.kvstore.RotationStrategy;
import org.neo4j.kernel.impl.store.kvstore.RotationTimeoutException;
import org.neo4j.kernel.impl.store.kvstore.RotationTimerFactory;
import org.neo4j.kernel.impl.store.kvstore.ValueSink;
import org.neo4j.kernel.impl.store.kvstore.ValueUpdate;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.test.rule.Resources;
import org.neo4j.test.rule.concurrent.ThreadingRule;
import org.neo4j.time.Clocks;

public class AbstractKeyValueStoreTest {
    private final ExpectedException expectedException = ExpectedException.none();
    private final Resources resourceManager = new Resources(Resources.TestPath.FILE_IN_EXISTING_DIRECTORY);
    @Rule
    public final ThreadingRule threading = new ThreadingRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.expectedException).around((TestRule)this.resourceManager);
    private static final HeaderField<Long> TX_ID = new HeaderField<Long>(){

        public Long read(ReadableBuffer header) {
            return header.getLong(header.size() - 8);
        }

        public void write(Long value, WritableBuffer header) {
            header.putLong(header.size() - 8, value.longValue());
        }

        public String toString() {
            return "txId";
        }
    };

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void retryLookupOnConcurrentStoreStateChange() throws IOException {
        Store testStore = this.resourceManager.managed(this.createTestStore(TimeUnit.DAYS.toMillis(2L)));
        ConcurrentMapState newState = new ConcurrentMapState((ReadableState)testStore.state, (File)Mockito.mock(File.class));
        testStore.put("test", "value");
        CountingErroneousReader countingErroneousReader = new CountingErroneousReader(testStore, (ProgressiveState<String>)newState);
        Assert.assertEquals((String)"New state contains stored value", (Object)"value", (Object)testStore.lookup("test", countingErroneousReader));
        Assert.assertEquals((String)"Should have 2 invocations: first throws exception, second re-read value.", (long)2L, (long)countingErroneousReader.getInvocationCounter());
    }

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void accessClosedStateCauseIllegalStateException() throws Exception {
        Store store = this.resourceManager.managed(new Store(new HeaderField[0]));
        store.put("test", "value");
        store.prepareRotation(0L).rotate();
        ProgressiveState lookupState = store.state;
        store.prepareRotation(0L).rotate();
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("File has been unmapped");
        lookupState.lookup((Object)"test", new ValueSink(){

            protected void value(ReadableBuffer value) {
            }
        });
    }

    @Test
    public void shouldStartAndStopStore() throws Exception {
        this.resourceManager.managed(new Store(new HeaderField[0]));
        this.resourceManager.lifeStarts();
        this.resourceManager.lifeShutsDown();
    }

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void shouldRotateStore() throws Exception {
        Store store = this.resourceManager.managed(new Store(new HeaderField[0]));
        store.prepareRotation(0L).rotate();
    }

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void shouldStoreEntries() throws Exception {
        Store store = this.resourceManager.managed(new Store(new HeaderField[0]));
        store.put("message", "hello world");
        store.put("age", "too old");
        Assert.assertEquals((Object)"hello world", (Object)store.get("message"));
        Assert.assertEquals((Object)"too old", (Object)store.get("age"));
        store.prepareRotation(0L).rotate();
        Assert.assertEquals((Object)"hello world", (Object)store.get("message"));
        Assert.assertEquals((Object)"too old", (Object)store.get("age"));
    }

    @Test
    public void shouldPickFileWithGreatestTransactionId() throws Exception {
        Store store;
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            store = (Store)life.add((Lifecycle)this.createTestStore());
            for (long txId = 2L; txId <= 10L; ++txId) {
                ((EntryUpdater)store.updater(txId).get()).close();
                store.prepareRotation(txId).rotate();
            }
        }
        life = new Lifespan(new Lifecycle[0]);
        var2_2 = null;
        try {
            store = (Store)life.add((Lifecycle)this.createTestStore());
            Assert.assertEquals((long)10L, (long)((Long)store.headers().get(TX_ID)));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (life != null) {
                if (var2_2 != null) {
                    try {
                        life.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    life.close();
                }
            }
        }
    }

    @Test
    public void shouldNotPickCorruptStoreFile() throws Exception {
        ByteBuffer value;
        Store store = this.createTestStore();
        RotationStrategy rotation = store.rotationStrategy;
        File[] files = new File[10];
        Pair file = rotation.create(DataProvider.EMPTY_DATA_PROVIDER, 1L);
        files[0] = (File)file.first();
        int txId = 2;
        for (int i = 1; i < files.length; ++i) {
            KeyValueStoreFile old = (KeyValueStoreFile)file.other();
            final int data = txId;
            file = rotation.next((File)file.first(), Headers.headersBuilder().put(TX_ID, (Object)txId).headers(), AbstractKeyValueStoreTest.data(new Entry(){

                @Override
                public void write(WritableBuffer key, WritableBuffer value) {
                    key.putByte(0, (byte)102);
                    key.putByte(1, (byte)111);
                    key.putByte(2, (byte)111);
                    value.putInt(0, data);
                }
            }));
            old.close();
            files[i] = (File)file.first();
            txId <<= 1;
        }
        ((KeyValueStoreFile)file.other()).close();
        try (StoreChannel channel = this.resourceManager.fileSystem().open(files[9], "rw");){
            channel.position(16L);
            value = ByteBuffer.allocate(16);
            value.put((byte)0);
            value.flip();
            channel.writeAll(value);
        }
        channel = this.resourceManager.fileSystem().open(files[8], "rw");
        var5_6 = null;
        try {
            channel.position(32L);
            value = ByteBuffer.allocate(16);
            value.put((byte)17);
            value.flip();
            channel.writeAll(value);
        }
        catch (Throwable value2) {
            var5_6 = value2;
            throw value2;
        }
        finally {
            if (channel != null) {
                if (var5_6 != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable value2) {
                        var5_6.addSuppressed(value2);
                    }
                } else {
                    channel.close();
                }
            }
        }
        channel = this.resourceManager.fileSystem().open(files[7], "rw");
        var5_6 = null;
        try {
            channel.position(112L);
            value = ByteBuffer.allocate(16);
            value.putLong(0L);
            value.putLong(0L);
            value.flip();
            channel.writeAll(value);
        }
        catch (Throwable throwable) {
            var5_6 = throwable;
            throw throwable;
        }
        finally {
            if (channel != null) {
                if (var5_6 != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable throwable) {
                        var5_6.addSuppressed(throwable);
                    }
                } else {
                    channel.close();
                }
            }
        }
        var5_6 = null;
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            life.add((Lifecycle)store);
            Assert.assertEquals((long)64L, (long)((Long)store.headers().get(TX_ID)));
        }
        catch (Throwable throwable) {
            var5_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldPickTheUncorruptedStoreWhenTruncatingAfterTheHeader() throws IOException {
        Store store = this.createTestStore();
        Pair file = store.rotationStrategy.create(DataProvider.EMPTY_DATA_PROVIDER, 1L);
        Pair next = store.rotationStrategy.next((File)file.first(), Headers.headersBuilder().put(TX_ID, (Object)42L).headers(), AbstractKeyValueStoreTest.data(new Entry(){

            @Override
            public void write(WritableBuffer key, WritableBuffer value) {
                key.putByte(0, (byte)102);
                key.putByte(1, (byte)111);
                key.putByte(2, (byte)111);
                value.putInt(0, 42);
            }
        }));
        ((KeyValueStoreFile)file.other()).close();
        File correct = (File)next.first();
        Pair nextNext = store.rotationStrategy.next(correct, Headers.headersBuilder().put(TX_ID, (Object)43L).headers(), AbstractKeyValueStoreTest.data(new Entry(){

            @Override
            public void write(WritableBuffer key, WritableBuffer value) {
                key.putByte(0, (byte)102);
                key.putByte(1, (byte)111);
                key.putByte(2, (byte)111);
                value.putInt(0, 42);
            }
        }, new Entry(){

            @Override
            public void write(WritableBuffer key, WritableBuffer value) {
                key.putByte(0, (byte)98);
                key.putByte(1, (byte)97);
                key.putByte(2, (byte)114);
                value.putInt(0, 4242);
            }
        }));
        ((KeyValueStoreFile)next.other()).close();
        File corrupted = (File)nextNext.first();
        ((KeyValueStoreFile)nextNext.other()).close();
        try (StoreChannel channel = this.resourceManager.fileSystem().open(corrupted, "rw");){
            channel.truncate(64L);
        }
        var8_8 = null;
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            life.add((Lifecycle)store);
            Assert.assertNotNull((Object)store.get("foo"));
            Assert.assertEquals((long)42L, (long)((Long)store.headers().get(TX_ID)));
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
    }

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void shouldRotateWithCorrectVersion() throws Exception {
        Store store = this.resourceManager.managed(this.createTestStore());
        this.updateStore(store, 1L);
        PreparedRotation rotation = store.prepareRotation(2L);
        this.updateStore(store, 2L);
        rotation.rotate();
        Assert.assertEquals((long)2L, (long)((Long)store.headers().get(TX_ID)));
        store.prepareRotation(2L).rotate();
    }

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void postStateUpdatesCountedOnlyForTransactionsGreaterThanRotationVersion() throws IOException, TimeoutException, InterruptedException, ExecutionException {
        Store store = this.resourceManager.managed(this.createTestStore());
        PreparedRotation rotation = store.prepareRotation(2L);
        this.updateStore(store, 4L);
        this.updateStore(store, 3L);
        this.updateStore(store, 1L);
        this.updateStore(store, 2L);
        Assert.assertEquals((long)2L, (long)rotation.rotate());
        Future rotationFuture = this.threading.executeAndAwait(store.rotation, 5L, thread -> Thread.State.TIMED_WAITING == thread.getState(), 100L, TimeUnit.SECONDS);
        Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        Assert.assertFalse((boolean)rotationFuture.isDone());
        this.updateStore(store, 5L);
        Assert.assertEquals((long)5L, (long)((Long)rotationFuture.get()));
    }

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void shouldBlockRotationUntilRequestedTransactionsAreApplied() throws Exception {
        Store store = this.resourceManager.managed(this.createTestStore());
        this.updateStore(store, 1L);
        Future rotation = this.threading.executeAndAwait(store.rotation, 3L, thread -> {
            switch (thread.getState()) {
                case BLOCKED: 
                case WAITING: 
                case TIMED_WAITING: 
                case TERMINATED: {
                    return true;
                }
            }
            return false;
        }, 100L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)rotation.isDone());
        TimeUnit.SECONDS.sleep(1L);
        Assert.assertFalse((boolean)rotation.isDone());
        this.updateStore(store, 3L);
        Assert.assertFalse((boolean)rotation.isDone());
        TimeUnit.SECONDS.sleep(1L);
        Assert.assertFalse((boolean)rotation.isDone());
        this.updateStore(store, 4L);
        Assert.assertFalse((boolean)rotation.isDone());
        TimeUnit.SECONDS.sleep(1L);
        Assert.assertFalse((boolean)rotation.isDone());
        this.updateStore(store, 2L);
        Assert.assertEquals((long)3L, (long)((Long)rotation.get()));
        Assert.assertEquals((long)3L, (long)((Long)store.headers().get(TX_ID)));
        store.rotation.apply((Object)4L);
    }

    @Test(timeout=2000L)
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void shouldFailRotationAfterTimeout() throws IOException {
        Store store = this.resourceManager.managed(this.createTestStore(0L));
        this.expectedException.expect(RotationTimeoutException.class);
        store.prepareRotation(10L).rotate();
    }

    private Store createTestStore() {
        return this.createTestStore(TimeUnit.SECONDS.toMillis(100L));
    }

    private Store createTestStore(long rotationTimeout) {
        return new Store(rotationTimeout, new HeaderField[]{TX_ID}){

            @Override
            <Value> Value initialHeader(HeaderField<Value> field) {
                if (field == TX_ID) {
                    return (Value)Long.valueOf(1L);
                }
                return super.initialHeader(field);
            }

            @Override
            protected void updateHeaders(Headers.Builder headers, long version) {
                headers.put(TX_ID, (Object)version);
            }

            @Override
            protected int compareHeaders(Headers lhs, Headers rhs) {
                return Long.compare((Long)lhs.get(TX_ID), (Long)rhs.get(TX_ID));
            }
        };
    }

    private void updateStore(Store store, long transaction) throws IOException {
        ThrowingConsumer update = u -> {
            try (EntryUpdater updater = (EntryUpdater)store.updater((long)u).get();){
                updater.apply((Object)("key " + u), store.value("value " + u));
            }
        };
        update.accept((Object)transaction);
    }

    private static DataProvider data(final Entry ... data) {
        return new DataProvider(){
            int i;

            public boolean visit(WritableBuffer key, WritableBuffer value) throws IOException {
                if (this.i < data.length) {
                    data[this.i++].write(key, value);
                    return true;
                }
                return false;
            }

            public void close() throws IOException {
            }
        };
    }

    @Rotation(value=Rotation.Strategy.INCREMENTING)
    class Store
    extends AbstractKeyValueStore<String> {
        private final HeaderField<?>[] headerFields;
        final IOFunction<Long, Long> rotation;

        private Store(HeaderField<?> ... headerFields) {
            this(TimeUnit.MINUTES.toMillis(10L), headerFields);
        }

        private Store(long rotationTimeout, HeaderField<?> ... headerFields) {
            super(AbstractKeyValueStoreTest.this.resourceManager.fileSystem(), AbstractKeyValueStoreTest.this.resourceManager.pageCache(), AbstractKeyValueStoreTest.this.resourceManager.testPath(), null, new RotationTimerFactory(Clocks.systemClock(), rotationTimeout), 16, 16, headerFields);
            this.rotation = version -> this.prepareRotation((long)version).rotate();
            this.headerFields = headerFields;
            this.setEntryUpdaterInitializer((DataInitializer)new DataInitializer<EntryUpdater<String>>(){

                public void initialize(EntryUpdater<String> stringEntryUpdater) {
                }

                public long initialVersion() {
                    return 0L;
                }
            });
        }

        protected Headers initialHeaders(long version) {
            Headers.Builder builder = Headers.headersBuilder();
            for (HeaderField<?> field : this.headerFields) {
                this.putHeader(builder, field);
            }
            return builder.headers();
        }

        private <Value> void putHeader(Headers.Builder builder, HeaderField<Value> field) {
            builder.put(field, this.initialHeader(field));
        }

        <Value> Value initialHeader(HeaderField<Value> field) {
            return null;
        }

        protected int compareHeaders(Headers lhs, Headers rhs) {
            return 0;
        }

        protected void writeKey(String key, WritableBuffer buffer) {
            for (int i = 0; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (c == '\u0000' || c >= '\u0080') {
                    throw new IllegalArgumentException("Only ASCII keys allowed.");
                }
                buffer.putByte(i, (byte)c);
            }
        }

        protected String readKey(ReadableBuffer key) {
            char c;
            StringBuilder result = new StringBuilder(16);
            for (int i = 0; i < key.size() && (c = (char)(0xFF & key.getByte(i))) != '\u0000'; ++i) {
                result.append(c);
            }
            return result.toString();
        }

        protected void updateHeaders(Headers.Builder headers, long version) {
            headers.put(TX_ID, (Object)version);
        }

        protected long version(Headers headers) {
            Long transactionId = (Long)headers.get(TX_ID);
            return Math.max(1L, transactionId != null ? transactionId : 1L);
        }

        protected void writeFormatSpecifier(WritableBuffer formatSpecifier) {
            formatSpecifier.putByte(0, (byte)-1);
            formatSpecifier.putByte(formatSpecifier.size() - 1, (byte)-1);
        }

        public void put(String key, String value) throws IOException {
            try (EntryUpdater updater = this.updater();){
                updater.apply((Object)key, this.value(value));
            }
        }

        ValueUpdate value(String value) {
            return target -> this.writeKey(value, target);
        }

        public String get(String key) throws IOException {
            return (String)this.lookup(key, (AbstractKeyValueStore.Reader)new AbstractKeyValueStore.Reader<String>(){

                protected String parseValue(ReadableBuffer value) {
                    return Store.this.readKey(value);
                }
            });
        }
    }

    private static class CountingErroneousReader
    extends AbstractKeyValueStore.Reader<String> {
        private final Store testStore;
        private final ProgressiveState<String> newStoreState;
        private int invocationCounter;

        CountingErroneousReader(Store testStore, ProgressiveState<String> newStoreState) {
            this.testStore = testStore;
            this.newStoreState = newStoreState;
            this.invocationCounter = 0;
        }

        protected String parseValue(ReadableBuffer value) {
            ++this.invocationCounter;
            if (this.invocationCounter == 1) {
                this.testStore.state = this.newStoreState;
                throw new IllegalStateException("Exception during state rotation.");
            }
            return this.testStore.readKey(value);
        }

        int getInvocationCounter() {
            return this.invocationCounter;
        }
    }

    static interface Entry {
        public void write(WritableBuffer var1, WritableBuffer var2);
    }
}

