/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.countStore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;

public class IntermediateStateTestManager {
    private volatile int id = 1;
    private List<ConcurrentHashMap<CountsKey, long[]>> intermediateStateMaps = new ArrayList<ConcurrentHashMap<CountsKey, long[]>>();
    private Iterator<ConcurrentHashMap<CountsKey, long[]>> maps;
    static final int LARGEST_KEY = 5;

    public IntermediateStateTestManager() {
        this.intermediateStateMaps.add(new ConcurrentHashMap());
        this.maps = new Iterator<ConcurrentHashMap<CountsKey, long[]>>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public ConcurrentHashMap<CountsKey, long[]> next() {
                ConcurrentHashMap map = IntermediateStateTestManager.this.allOnesMap();
                ConcurrentHashMap nextMap = IntermediateStateTestManager.copyOfMap((ConcurrentHashMap)IntermediateStateTestManager.this.intermediateStateMaps.get(IntermediateStateTestManager.this.intermediateStateMaps.size() - 1));
                IntermediateStateTestManager.applyDiffToMap(nextMap, map);
                IntermediateStateTestManager.this.intermediateStateMaps.add(nextMap);
                return map;
            }
        };
    }

    private static ConcurrentHashMap<CountsKey, long[]> copyOfMap(ConcurrentHashMap<CountsKey, long[]> nextMap) {
        ConcurrentHashMap<CountsKey, long[]> newMap = new ConcurrentHashMap<CountsKey, long[]>();
        nextMap.forEach((key, value) -> newMap.put((CountsKey)key, Arrays.copyOf(value, ((long[])value).length)));
        return newMap;
    }

    private static ConcurrentHashMap<CountsKey, long[]> applyDiffToMap(ConcurrentHashMap<CountsKey, long[]> map, ConcurrentHashMap<CountsKey, long[]> diff) {
        diff.forEach((key, value) -> map.compute((CountsKey)key, (k, v) -> v == null ? Arrays.copyOf(value, ((long[])value).length) : IntermediateStateTestManager.updateEachValue(v, value)));
        return map;
    }

    private static long[] updateEachValue(long[] v, long[] diff) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i] + diff[i];
        }
        return v;
    }

    public synchronized ConcurrentHashMap<CountsKey, long[]> getIntermediateMap(int txId) {
        return this.intermediateStateMaps.get(txId);
    }

    public synchronized int getNextUpdateMap(Map<CountsKey, long[]> map) {
        if (this.maps.hasNext()) {
            map.clear();
            map.putAll((Map<CountsKey, long[]>)this.maps.next());
            return this.id++;
        }
        return -1;
    }

    public int getId() {
        return this.id;
    }

    private ConcurrentHashMap<CountsKey, long[]> allOnesMap() {
        ConcurrentHashMap<CountsKey, long[]> pairs = new ConcurrentHashMap<CountsKey, long[]>();
        for (int i = 0; i < 5; ++i) {
            pairs.put((CountsKey)CountsKeyFactory.nodeKey((int)i), new long[]{1L});
        }
        return pairs;
    }
}

