/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.countStore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.impl.store.countStore.CountsSnapshot;
import org.neo4j.kernel.impl.store.countStore.CountsSnapshotDeserializer;
import org.neo4j.kernel.impl.store.countStore.CountsSnapshotSerializer;
import org.neo4j.kernel.impl.store.countStore.InMemoryCountsStore;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyType;
import org.neo4j.kernel.impl.store.counts.keys.IndexSampleKey;
import org.neo4j.kernel.impl.store.counts.keys.IndexStatisticsKey;
import org.neo4j.kernel.impl.store.counts.keys.NodeKey;
import org.neo4j.kernel.impl.store.counts.keys.RelationshipKey;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosableChannel;

public class InMemoryCountsStoreSnapshotDeserializerTest {
    InMemoryClosableChannel logChannel;
    CountsSnapshot countsSnapshot;
    ByteBuffer serializedBytes;

    @Before
    public void setup() throws IOException {
        this.logChannel = new InMemoryClosableChannel();
        this.countsSnapshot = new CountsSnapshot(1L, new ConcurrentHashMap());
    }

    @After
    public void after() throws IOException {
        this.logChannel.close();
    }

    @Test
    public void correctlyDeserializeTxId() throws IOException {
        this.serializedBytes = ByteBuffer.allocate(1000);
        InMemoryClosableChannel logChannel = new InMemoryClosableChannel(this.serializedBytes.array(), false);
        logChannel.putLong(72L);
        logChannel.putInt(0);
        CountsSnapshot countsSnapshot = CountsSnapshotDeserializer.deserialize((ReadableClosableChannel)logChannel);
        Assert.assertEquals((long)72L, (long)countsSnapshot.getTxId());
    }

    @Test
    public void correctlyDeserializeTxIdAndMapSize() throws IOException {
        InMemoryCountsStore countStore = new InMemoryCountsStore();
        HashMap<NodeKey, long[]> updates = new HashMap<NodeKey, long[]>();
        updates.put(CountsKeyFactory.nodeKey((int)1), new long[]{1L});
        updates.put(CountsKeyFactory.nodeKey((int)2), new long[]{1L});
        updates.put(CountsKeyFactory.nodeKey((int)3), new long[]{1L});
        countStore.updateAll(1L, updates);
        this.serializedBytes = ByteBuffer.allocate(1000);
        InMemoryClosableChannel logChannel = new InMemoryClosableChannel(this.serializedBytes.array(), false);
        CountsSnapshotSerializer.serialize((FlushableChannel)logChannel, (CountsSnapshot)countStore.snapshot(1L));
        this.serializedBytes.position(8);
        this.serializedBytes.putInt(2);
        CountsSnapshot countsSnapshot = CountsSnapshotDeserializer.deserialize((ReadableClosableChannel)logChannel);
        Assert.assertEquals((long)2L, (long)countsSnapshot.getMap().size());
    }

    @Test
    public void correctlyDeserializeEntityNode() throws IOException {
        this.serializedBytes = ByteBuffer.allocate(1000);
        InMemoryClosableChannel logChannel = new InMemoryClosableChannel(this.serializedBytes.array(), false);
        this.writeSimpleHeader(logChannel);
        logChannel.put(CountsKeyType.ENTITY_NODE.code);
        logChannel.putInt(1);
        logChannel.putLong(1L);
        NodeKey expectedNode = CountsKeyFactory.nodeKey((int)1);
        CountsSnapshot countsSnapshot = CountsSnapshotDeserializer.deserialize((ReadableClosableChannel)logChannel);
        Assert.assertNotNull(countsSnapshot.getMap().get(expectedNode));
        Assert.assertArrayEquals((long[])new long[]{1L}, (long[])((long[])countsSnapshot.getMap().get(expectedNode)));
    }

    @Test
    public void correctlyDeserializeEntityRelationship() throws IOException {
        this.serializedBytes = ByteBuffer.allocate(1000);
        InMemoryClosableChannel logChannel = new InMemoryClosableChannel(this.serializedBytes.array(), false);
        this.writeSimpleHeader(logChannel);
        logChannel.put(CountsKeyType.ENTITY_RELATIONSHIP.code);
        logChannel.putInt(1);
        logChannel.putInt(1);
        logChannel.putInt(1);
        logChannel.putLong(1L);
        RelationshipKey expectedNode = CountsKeyFactory.relationshipKey((int)1, (int)1, (int)1);
        CountsSnapshot countsSnapshot = CountsSnapshotDeserializer.deserialize((ReadableClosableChannel)logChannel);
        Assert.assertNotNull(countsSnapshot.getMap().get(expectedNode));
        Assert.assertArrayEquals((long[])new long[]{1L}, (long[])((long[])countsSnapshot.getMap().get(expectedNode)));
    }

    @Test
    public void correctlyDeserializeIndexSample() throws IOException {
        this.serializedBytes = ByteBuffer.allocate(1000);
        InMemoryClosableChannel logChannel = new InMemoryClosableChannel(this.serializedBytes.array(), false);
        this.writeSimpleHeader(logChannel);
        logChannel.put(CountsKeyType.INDEX_SAMPLE.code);
        logChannel.putInt(1);
        logChannel.putInt(1);
        logChannel.putLong(1L);
        logChannel.putLong(1L);
        IndexSampleKey expectedNode = CountsKeyFactory.indexSampleKey((int)1, (int)1);
        CountsSnapshot countsSnapshot = CountsSnapshotDeserializer.deserialize((ReadableClosableChannel)logChannel);
        Assert.assertNotNull(countsSnapshot.getMap().get(expectedNode));
        Assert.assertArrayEquals((long[])new long[]{1L, 1L}, (long[])((long[])countsSnapshot.getMap().get(expectedNode)));
    }

    @Test
    public void correctlyDeserializeIndexStatistics() throws IOException {
        this.serializedBytes = ByteBuffer.allocate(1000);
        InMemoryClosableChannel logChannel = new InMemoryClosableChannel(this.serializedBytes.array(), false);
        this.writeSimpleHeader(logChannel);
        logChannel.put(CountsKeyType.INDEX_STATISTICS.code);
        logChannel.putInt(1);
        logChannel.putInt(1);
        logChannel.putLong(1L);
        logChannel.putLong(1L);
        IndexStatisticsKey expectedNode = CountsKeyFactory.indexStatisticsKey((int)1, (int)1);
        CountsSnapshot countsSnapshot = CountsSnapshotDeserializer.deserialize((ReadableClosableChannel)logChannel);
        Assert.assertNotNull(countsSnapshot.getMap().get(expectedNode));
        Assert.assertArrayEquals((long[])new long[]{1L, 1L}, (long[])((long[])countsSnapshot.getMap().get(expectedNode)));
    }

    private void writeSimpleHeader(InMemoryClosableChannel logChannel) throws IOException {
        logChannel.putLong(1L);
        logChannel.putInt(1);
    }
}

