/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsAllocator;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class NodeRecordTest {
    @Test
    public void cloneShouldProduceExactCopy() throws Exception {
        long relId = 1337L;
        long propId = 1338L;
        long inlinedLabels = 12L;
        NodeRecord node = new NodeRecord(1L, false, relId, propId);
        node.setLabelField(inlinedLabels, Arrays.asList(new DynamicRecord(1L), new DynamicRecord(2L)));
        node.setInUse(true);
        NodeRecord clone = node.clone();
        Assert.assertEquals((Object)node.inUse(), (Object)clone.inUse());
        Assert.assertEquals((long)node.getLabelField(), (long)clone.getLabelField());
        Assert.assertEquals((long)node.getNextProp(), (long)clone.getNextProp());
        Assert.assertEquals((long)node.getNextRel(), (long)clone.getNextRel());
        Assert.assertThat((Object)clone.getDynamicLabelRecords(), (Matcher)IsEqual.equalTo((Object)node.getDynamicLabelRecords()));
    }

    @Test
    public void shouldListLabelRecordsInUse() throws Exception {
        NodeRecord node = new NodeRecord(1L, false, -1L, -1L);
        long inlinedLabels = 12L;
        DynamicRecord dynamic1 = DynamicRecord.dynamicRecord((long)1L, (boolean)true);
        DynamicRecord dynamic2 = DynamicRecord.dynamicRecord((long)2L, (boolean)true);
        DynamicRecord dynamic3 = DynamicRecord.dynamicRecord((long)3L, (boolean)true);
        node.setLabelField(inlinedLabels, Arrays.asList(dynamic1, dynamic2, dynamic3));
        dynamic3.setInUse(false);
        Iterable usedRecords = node.getUsedDynamicLabelRecords();
        Assert.assertThat((Object)Iterables.asList((Iterable)usedRecords), (Matcher)IsEqual.equalTo(Arrays.asList(dynamic1, dynamic2)));
    }

    @Test
    public void shouldToStringBothUsedAndUnusedDynamicLabelRecords() throws Exception {
        IdSequence ids = (IdSequence)Mockito.mock(IdSequence.class);
        Mockito.when((Object)ids.nextId()).thenReturn((Object)1L, (Object[])new Long[]{2L});
        ReusableRecordsAllocator recordAllocator = new ReusableRecordsAllocator(30, new DynamicRecord[]{new DynamicRecord(1L), new DynamicRecord(2L)});
        NodeRecord node = this.newUsedNodeRecord(0L);
        long labelId = 10123L;
        Collection existing = DynamicNodeLabels.allocateRecordsForDynamicLabels((long)node.getId(), (long[])new long[]{labelId}, (DynamicRecordAllocator)recordAllocator);
        DynamicRecord unused = this.newDeletedDynamicRecord(ids.nextId());
        unused.setInUse(false);
        existing.add(unused);
        node.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)existing), existing);
        String toString = node.toString();
        Assert.assertThat((Object)toString, (Matcher)Matchers.containsString((String)String.valueOf(labelId)));
        Assert.assertThat((Object)toString, (Matcher)Matchers.containsString((String)unused.toString()));
    }

    private DynamicRecord newDeletedDynamicRecord(long id) {
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(false);
        return record;
    }

    private NodeRecord newUsedNodeRecord(long id) {
        NodeRecord node = new NodeRecord(id);
        node.setInUse(true);
        return node;
    }
}

