/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.ArrayQueueOutOfOrderSequence;
import org.neo4j.kernel.impl.util.OutOfOrderSequence;

public class ArrayQueueOutOfOrderSequenceTest {
    private final long[] EMPTY_META = new long[]{42L};

    @Test
    public void shouldExposeGapFreeSequenceSingleThreaded() throws Exception {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 10, new long[1]);
        this.offer((OutOfOrderSequence)sequence, 1L, new long[]{1L});
        this.assertGet((OutOfOrderSequence)sequence, 1L, new long[]{1L});
        this.offer((OutOfOrderSequence)sequence, 2L, new long[]{2L});
        this.assertGet((OutOfOrderSequence)sequence, 2L, new long[]{2L});
        Assert.assertFalse((boolean)sequence.seen(4L, new long[]{3L}));
        sequence.offer(4L, new long[]{3L});
        this.assertGet((OutOfOrderSequence)sequence, 2L, new long[]{2L});
        this.offer((OutOfOrderSequence)sequence, 3L, new long[]{4L});
        this.assertGet((OutOfOrderSequence)sequence, 4L, new long[]{3L});
        this.offer((OutOfOrderSequence)sequence, 5L, new long[]{5L});
        this.assertGet((OutOfOrderSequence)sequence, 5L, new long[]{5L});
        this.offer((OutOfOrderSequence)sequence, 10L, new long[]{6L});
        this.offer((OutOfOrderSequence)sequence, 11L, new long[]{7L});
        this.offer((OutOfOrderSequence)sequence, 8L, new long[]{8L});
        this.offer((OutOfOrderSequence)sequence, 9L, new long[]{9L});
        this.offer((OutOfOrderSequence)sequence, 7L, new long[]{10L});
        this.assertGet((OutOfOrderSequence)sequence, 5L, new long[]{5L});
        this.offer((OutOfOrderSequence)sequence, 6L, new long[]{11L});
        this.assertGet((OutOfOrderSequence)sequence, 11L, new long[]{7L});
    }

    @Test
    public void shouldExtendArrayIfNeedBe() throws Exception {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5, new long[1]);
        this.offer((OutOfOrderSequence)sequence, 3L, new long[]{0L});
        this.offer((OutOfOrderSequence)sequence, 2L, new long[]{1L});
        this.offer((OutOfOrderSequence)sequence, 5L, new long[]{2L});
        this.offer((OutOfOrderSequence)sequence, 4L, new long[]{3L});
        this.offer((OutOfOrderSequence)sequence, 6L, new long[]{4L});
        this.offer((OutOfOrderSequence)sequence, 1L, new long[]{5L});
        this.assertGet((OutOfOrderSequence)sequence, 6L, new long[]{4L});
    }

    @Test
    public void shouldDealWithThisScenario() throws Exception {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5, new long[1]);
        Assert.assertTrue((boolean)this.offer((OutOfOrderSequence)sequence, 1L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 3L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 4L, new long[]{0L}));
        Assert.assertTrue((boolean)this.offer((OutOfOrderSequence)sequence, 2L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 6L, new long[]{0L}));
        Assert.assertTrue((boolean)this.offer((OutOfOrderSequence)sequence, 5L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 8L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 9L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 10L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 11L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 12L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 13L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 14L, new long[]{0L}));
        Assert.assertTrue((boolean)this.offer((OutOfOrderSequence)sequence, 7L, new long[]{0L}));
        this.assertGet((OutOfOrderSequence)sequence, 14L, new long[]{0L});
    }

    @Test
    public void shouldKeepItsCoolWhenMultipleThreadsAreHammeringIt() throws Exception {
        final AtomicLong numberSource = new AtomicLong();
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(numberSource.get(), 5, new long[1]);
        final AtomicBoolean end = new AtomicBoolean();
        final CountDownLatch startSignal = new CountDownLatch(1);
        Thread[] threads = new Thread[1];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread((OutOfOrderSequence)sequence){
                final /* synthetic */ OutOfOrderSequence val$sequence;
                {
                    this.val$sequence = outOfOrderSequence;
                }

                @Override
                public void run() {
                    ArrayQueueOutOfOrderSequenceTest.this.await(startSignal);
                    while (!end.get()) {
                        long number = numberSource.incrementAndGet();
                        ArrayQueueOutOfOrderSequenceTest.this.offer(this.val$sequence, number, new long[]{number + 2L});
                    }
                }
            };
        }
        for (Thread thread : threads) {
            thread.start();
        }
        startSignal.countDown();
        while (numberSource.get() < 10000000L) {
            Thread.sleep(1L);
            Thread.yield();
        }
        end.set(true);
        for (Thread thread : threads) {
            thread.join();
        }
        long lastNumber = numberSource.get();
        this.assertGet((OutOfOrderSequence)sequence, lastNumber, new long[]{lastNumber + 2L});
    }

    @Test
    public void highestEverSeenTest() {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5, this.EMPTY_META);
        Assert.assertEquals((long)0L, (long)sequence.highestEverSeen());
        sequence.offer(1L, this.EMPTY_META);
        Assert.assertEquals((long)1L, (long)sequence.highestEverSeen());
        sequence.offer(42L, this.EMPTY_META);
        Assert.assertEquals((long)42L, (long)sequence.highestEverSeen());
    }

    private boolean offer(OutOfOrderSequence sequence, long number, long[] meta) {
        Assert.assertFalse((boolean)sequence.seen(number, meta));
        boolean result = sequence.offer(number, meta);
        Assert.assertTrue((boolean)sequence.seen(number, meta));
        return result;
    }

    private void assertGet(OutOfOrderSequence sequence, long number, long[] meta) {
        long[] data = sequence.get();
        long[] expected = new long[meta.length + 1];
        expected[0] = number;
        System.arraycopy(meta, 0, expected, 1, meta.length);
        Assert.assertArrayEquals((long[])expected, (long[])data);
    }

    private void await(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

