/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import org.apache.commons.lang3.RandomUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class AbstractDynamicStoreTest {
    private static final int BLOCK_SIZE = 60;
    @Rule
    public final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private final File fileName = new File("store");
    private final RecordFormats formats = StandardV3_0.RECORD_FORMATS;
    private PageCache pageCache;
    private FileSystemAbstraction fs;

    @Before
    public void before() throws IOException {
        this.fs = this.fsr.get();
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fsr.get());
        try (StoreChannel channel = this.fs.create(this.fileName);){
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(60);
            buffer.flip();
            channel.write(buffer);
        }
    }

    @Test
    public void dynamicRecordCursorReadsInUseRecords() {
        try (AbstractDynamicStore store = this.newTestableDynamicStore();){
            DynamicRecord first = this.createDynamicRecord(1L, store, 0);
            DynamicRecord second = this.createDynamicRecord(2L, store, 0);
            DynamicRecord third = this.createDynamicRecord(3L, store, 10);
            first.setNextBlock(second.getId());
            store.updateRecord((AbstractBaseRecord)first);
            second.setNextBlock(third.getId());
            store.updateRecord((AbstractBaseRecord)second);
            RecordCursor recordsCursor = store.newRecordCursor(store.newRecord()).acquire(1L, RecordLoad.NORMAL);
            Assert.assertTrue((boolean)recordsCursor.next());
            Assert.assertEquals((Object)first, (Object)recordsCursor.get());
            Assert.assertTrue((boolean)recordsCursor.next());
            Assert.assertEquals((Object)second, (Object)recordsCursor.get());
            Assert.assertTrue((boolean)recordsCursor.next());
            Assert.assertEquals((Object)third, (Object)recordsCursor.get());
            Assert.assertFalse((boolean)recordsCursor.next());
        }
    }

    @Test
    public void dynamicRecordCursorReadsNotInUseRecords() {
        try (AbstractDynamicStore store = this.newTestableDynamicStore();){
            DynamicRecord first = this.createDynamicRecord(1L, store, 0);
            DynamicRecord second = this.createDynamicRecord(2L, store, 0);
            DynamicRecord third = this.createDynamicRecord(3L, store, 10);
            first.setNextBlock(second.getId());
            store.updateRecord((AbstractBaseRecord)first);
            second.setNextBlock(third.getId());
            store.updateRecord((AbstractBaseRecord)second);
            second.setInUse(false);
            store.updateRecord((AbstractBaseRecord)second);
            RecordCursor recordsCursor = store.newRecordCursor(store.newRecord()).acquire(1L, RecordLoad.FORCE);
            Assert.assertTrue((boolean)recordsCursor.next());
            Assert.assertEquals((Object)first, (Object)recordsCursor.get());
            Assert.assertFalse((boolean)recordsCursor.next());
            Assert.assertEquals((Object)second, (Object)recordsCursor.get());
            Assert.assertTrue((boolean)recordsCursor.next());
            Assert.assertEquals((Object)third, (Object)recordsCursor.get());
            Assert.assertFalse((boolean)recordsCursor.next());
        }
    }

    private DynamicRecord createDynamicRecord(long id, AbstractDynamicStore store, int dataSize) {
        DynamicRecord first = new DynamicRecord(id);
        first.setInUse(true);
        first.setData(RandomUtils.nextBytes((int)(dataSize == 0 ? 60 - this.formats.dynamic().getRecordHeaderSize() : 10)));
        store.updateRecord((AbstractBaseRecord)first);
        return first;
    }

    private AbstractDynamicStore newTestableDynamicStore() {
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(this.fs);
        AbstractDynamicStore store = new AbstractDynamicStore(this.fileName, Config.empty(), IdType.ARRAY_BLOCK, (IdGeneratorFactory)idGeneratorFactory, this.pageCache, (LogProvider)NullLogProvider.getInstance(), "test", 60, this.formats.dynamic(), this.formats.storeVersion(), new OpenOption[0]){

            public void accept(RecordStore.Processor processor, DynamicRecord record) {
            }

            public String getTypeDescriptor() {
                return "TestDynamicStore";
            }
        };
        store.initialise(true);
        return store;
    }
}

