/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Key;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.UserFunctionSignature;
import org.neo4j.kernel.impl.proc.Procedures;

public class UserFunctionsTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final Procedures procs = new Procedures();
    private final UserFunctionSignature signature = UserFunctionSignature.functionSignature((String[])new String[]{"org", "myproc"}).out(Neo4jTypes.NTAny).build();
    private final CallableUserFunction function = this.function(this.signature);

    @Test
    public void shouldGetRegisteredFunction() throws Throwable {
        this.procs.register(this.function);
        Assert.assertThat(this.procs.function(this.signature.name()).get(), (Matcher)CoreMatchers.equalTo((Object)this.signature));
    }

    @Test
    public void shouldGetAllRegisteredFunctions() throws Throwable {
        this.procs.register(this.function(UserFunctionSignature.functionSignature((String[])new String[]{"org", "myproc1"}).out(Neo4jTypes.NTAny).build()));
        this.procs.register(this.function(UserFunctionSignature.functionSignature((String[])new String[]{"org", "myproc2"}).out(Neo4jTypes.NTAny).build()));
        this.procs.register(this.function(UserFunctionSignature.functionSignature((String[])new String[]{"org", "myproc3"}).out(Neo4jTypes.NTAny).build()));
        List signatures = Iterables.asList((Iterable)this.procs.getAllFunctions());
        Assert.assertThat((Object)signatures, (Matcher)Matchers.containsInAnyOrder((Object[])new UserFunctionSignature[]{UserFunctionSignature.functionSignature((String[])new String[]{"org", "myproc1"}).out(Neo4jTypes.NTAny).build(), UserFunctionSignature.functionSignature((String[])new String[]{"org", "myproc2"}).out(Neo4jTypes.NTAny).build(), UserFunctionSignature.functionSignature((String[])new String[]{"org", "myproc3"}).out(Neo4jTypes.NTAny).build()}));
    }

    @Test
    public void shouldCallRegisteredFunction() throws Throwable {
        this.procs.register(this.function);
        Object result = this.procs.callFunction((Context)new BasicContext(), this.signature.name(), new Object[]{1337});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)new Object[]{1337}));
    }

    @Test
    public void shouldNotAllowCallingNonExistingFunction() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("There is no function with the name `org.myproc` registered for this database instance. Please ensure you've spelled the function name correctly and that the function is properly deployed.");
        this.procs.callFunction((Context)new BasicContext(), this.signature.name(), new Object[]{1337});
    }

    @Test
    public void shouldNotAllowRegisteringConflictingName() throws Throwable {
        this.procs.register(this.function);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to register function, because the name `org.myproc` is already in use.");
        this.procs.register(this.function);
    }

    @Test
    public void shouldSignalNonExistingFunction() throws Throwable {
        Assert.assertThat((Object)this.procs.function(this.signature.name()), (Matcher)CoreMatchers.is(Optional.empty()));
    }

    @Test
    public void shouldMakeContextAvailable() throws Throwable {
        final Key someKey = Key.key((String)"someKey", String.class);
        this.procs.register((CallableUserFunction)new CallableUserFunction.BasicUserFunction(this.signature){

            public Object apply(Context ctx, Object[] input) throws ProcedureException {
                return ctx.get(someKey);
            }
        });
        BasicContext ctx = new BasicContext();
        ctx.put(someKey, (Object)"hello, world");
        Object result = this.procs.callFunction((Context)ctx, this.signature.name(), new Object[0]);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)"hello, world"));
    }

    private CallableUserFunction function(UserFunctionSignature signature) {
        return new CallableUserFunction.BasicUserFunction(signature){

            public Object apply(Context ctx, Object[] input) {
                return input;
            }
        };
    }
}

