/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.proc.ProcedureAllowedConfig;

public class ProcedureAllowedConfigTest {
    private static final String[] EMPTY = new String[0];

    private static String[] arrayOf(String ... values) {
        return values;
    }

    @Test
    public void shouldHaveEmptyDefaultConfigs() {
        Config config = Config.defaults();
        ProcedureAllowedConfig procConfig = new ProcedureAllowedConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("x"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
    }

    @Test
    public void shouldHaveConfigsWithDefaultProcedureAllowed() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.default_allowed", "role1"}), new Class[0]);
        ProcedureAllowedConfig procConfig = new ProcedureAllowedConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("x"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("role1")));
    }

    @Test
    public void shouldHaveConfigsWithExactMatchProcedureAllowed() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.default_allowed", "role1", "dbms.security.procedures.roles", "xyz:anotherRole"}), new Class[0]);
        ProcedureAllowedConfig procConfig = new ProcedureAllowedConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("xyz"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("anotherRole")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("abc"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("role1")));
    }

    @Test
    public void shouldHaveConfigsWithWildcardProcedureAllowed() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.default_allowed", "role1", "dbms.security.procedures.roles", "xyz*:anotherRole"}), new Class[0]);
        ProcedureAllowedConfig procConfig = new ProcedureAllowedConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("xyzabc"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("anotherRole")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("abcxyz"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("role1")));
    }

    @Test
    public void shouldHaveConfigsWithWildcardProcedureAllowedAndNoDefault() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.roles", "xyz*:anotherRole"}), new Class[0]);
        ProcedureAllowedConfig procConfig = new ProcedureAllowedConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("xyzabc"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("anotherRole")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("abcxyz"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
    }

    @Test
    public void shouldHaveConfigsWithMultipleWildcardProcedureAllowedAndNoDefault() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.roles", "apoc.convert.*:apoc_reader;apoc.load.json:apoc_writer;apoc.trigger.add:TriggerHappy"}), new Class[0]);
        ProcedureAllowedConfig procConfig = new ProcedureAllowedConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("xyz"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.convert.xml"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("apoc_reader")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.convert.json"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("apoc_reader")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.load.xml"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.load.json"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("apoc_writer")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.trigger.add"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("TriggerHappy")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.convert-json"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.load-xml"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.load-json"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.trigger-add"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
    }

    @Test
    public void shouldHaveConfigsWithOverlappingMatchingWildcards() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.default_allowed", "default", "dbms.security.procedures.roles", "apoc.*:apoc;apoc.load.*:loader;apoc.trigger.*:trigger;apoc.trigger.add:TriggerHappy"}), new Class[0]);
        ProcedureAllowedConfig procConfig = new ProcedureAllowedConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("xyz"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("default")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.convert.xml"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("apoc")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.load.xml"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("apoc", "loader")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.trigger.add"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("apoc", "trigger", "TriggerHappy")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.trigger.remove"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("apoc", "trigger")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.load-xml"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("apoc")));
    }

    @Test
    public void shouldSupportSeveralRolesPerPattern() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.roles", "xyz*:role1,role2,  role3  ,    role4   ;    abc:  role3   ,role1"}), new Class[0]);
        ProcedureAllowedConfig procConfig = new ProcedureAllowedConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("xyzabc"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("role1", "role2", "role3", "role4")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("abc"), (Matcher)CoreMatchers.equalTo((Object)ProcedureAllowedConfigTest.arrayOf("role3", "role1")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("abcxyz"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
    }
}

