/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.core.PropertyContainerProxyTest;
import org.neo4j.test.DoubleLatch;

public class NodeProxyTest
extends PropertyContainerProxyTest {
    private final String PROPERTY_KEY = "PROPERTY_KEY";

    @Override
    protected long createPropertyContainer() {
        return this.db.createNode().getId();
    }

    @Override
    protected PropertyContainer lookupPropertyContainer(long id) {
        return this.db.getNodeById(id);
    }

    @Test
    public void shouldThrowHumaneExceptionsWhenPropertyDoesNotExistOnNode() throws Exception {
        this.createNodeWith("PROPERTY_KEY");
        try (Transaction ignored = this.db.beginTx();){
            Node node = this.db.createNode();
            node.getProperty("PROPERTY_KEY");
            Assert.fail((String)"Expected exception to have been thrown");
        }
        catch (NotFoundException exception) {
            Assert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"PROPERTY_KEY"));
        }
    }

    @Test
    public void createDropNodeLongStringProperty() {
        Node node;
        Label markerLabel = Label.label((String)"marker");
        String testPropertyKey = "testProperty";
        String propertyValue = RandomStringUtils.randomAscii((int)255);
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode(markerLabel);
            node.setProperty(testPropertyKey, (Object)propertyValue);
            tx.success();
        }
        tx = this.db.beginTx();
        var5_5 = null;
        try {
            node = (Node)Iterators.single(this.db.findNodes(markerLabel));
            Assert.assertEquals((Object)propertyValue, (Object)node.getProperty(testPropertyKey));
            tx.success();
        }
        catch (Throwable node2) {
            var5_5 = node2;
            throw node2;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable node2) {
                        var5_5.addSuppressed(node2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var5_5 = null;
        try {
            node = (Node)Iterators.single(this.db.findNodes(markerLabel));
            node.removeProperty(testPropertyKey);
            tx.success();
        }
        catch (Throwable node3) {
            var5_5 = node3;
            throw node3;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable node3) {
                        var5_5.addSuppressed(node3);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var5_5 = null;
        try {
            node = (Node)Iterators.single(this.db.findNodes(markerLabel));
            Assert.assertFalse((boolean)node.hasProperty(testPropertyKey));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void createDropNodeLongArrayProperty() {
        Node node;
        Label markerLabel = Label.label((String)"marker");
        String testPropertyKey = "testProperty";
        byte[] propertyValue = RandomUtils.nextBytes((int)1024);
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode(markerLabel);
            node.setProperty(testPropertyKey, (Object)propertyValue);
            tx.success();
        }
        tx = this.db.beginTx();
        var5_5 = null;
        try {
            node = (Node)Iterators.single(this.db.findNodes(markerLabel));
            Assert.assertArrayEquals((byte[])propertyValue, (byte[])((byte[])node.getProperty(testPropertyKey)));
            tx.success();
        }
        catch (Throwable node2) {
            var5_5 = node2;
            throw node2;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable node2) {
                        var5_5.addSuppressed(node2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var5_5 = null;
        try {
            node = (Node)Iterators.single(this.db.findNodes(markerLabel));
            node.removeProperty(testPropertyKey);
            tx.success();
        }
        catch (Throwable node3) {
            var5_5 = node3;
            throw node3;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable node3) {
                        var5_5.addSuppressed(node3);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var5_5 = null;
        try {
            node = (Node)Iterators.single(this.db.findNodes(markerLabel));
            Assert.assertFalse((boolean)node.hasProperty(testPropertyKey));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldThrowHumaneExceptionsWhenPropertyDoesNotExist() throws Exception {
        try (Transaction ignored = this.db.beginTx();){
            Node node = this.db.createNode();
            node.getProperty("PROPERTY_KEY");
        }
        catch (NotFoundException exception) {
            Assert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"PROPERTY_KEY"));
        }
    }

    @Test(expected=NotFoundException.class)
    public void deletionOfSameNodeTwiceInOneTransactionShouldNotRollbackIt() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            tx.success();
        }
        Exception exceptionThrownBySecondDelete = null;
        try (Transaction tx = this.db.beginTx();){
            node.delete();
            try {
                node.delete();
            }
            catch (Exception e) {
                exceptionThrownBySecondDelete = e;
            }
            tx.success();
        }
        Assert.assertThat((Object)exceptionThrownBySecondDelete, (Matcher)Matchers.instanceOf(NotFoundException.class));
        tx = this.db.beginTx();
        var4_6 = null;
        try {
            this.db.getNodeById(node.getId());
            tx.success();
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_6 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_6.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test(expected=NotFoundException.class)
    public void deletionOfAlreadyDeletedNodeShouldThrow() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            tx.success();
        }
        tx = this.db.beginTx();
        var3_2 = null;
        try {
            node.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var3_2 = null;
        try {
            node.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void getAllPropertiesShouldWorkFineWithConcurrentPropertyModifications() throws Exception {
        long nodeId;
        ExecutorService executor = this.cleanup.add(Executors.newFixedThreadPool(2, (ThreadFactory)NamedThreadFactory.named((String)"Test-executor-thread")));
        int propertiesCount = 100;
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            nodeId = node.getId();
            for (int i = 0; i < 100; ++i) {
                node.setProperty("property-" + i, (Object)i);
            }
            tx.success();
        }
        final CountDownLatch start = new CountDownLatch(1);
        final AtomicBoolean writerDone = new AtomicBoolean();
        Runnable writer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DoubleLatch.awaitLatch(start);
                    int propertyKey = 0;
                    while (propertyKey < 100) {
                        Transaction tx = NodeProxyTest.this.db.beginTx();
                        Throwable throwable = null;
                        try {
                            Node node = NodeProxyTest.this.db.getNodeById(nodeId);
                            for (int i = 0; i < 10 && propertyKey < 100; ++i, ++propertyKey) {
                                node.setProperty("property-" + propertyKey, (Object)UUID.randomUUID().toString());
                            }
                            tx.success();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (tx == null) continue;
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            tx.close();
                        }
                    }
                }
                finally {
                    writerDone.set(true);
                }
            }
        };
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                try (Transaction tx = NodeProxyTest.this.db.beginTx();){
                    Node node = NodeProxyTest.this.db.getNodeById(nodeId);
                    DoubleLatch.awaitLatch(start);
                    while (!writerDone.get()) {
                        int size = node.getAllProperties().size();
                        Assert.assertThat((Object)size, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
                    }
                    tx.success();
                }
            }
        };
        Future<?> readerFuture = executor.submit(reader);
        Future<?> writerFuture = executor.submit(writer);
        start.countDown();
        writerFuture.get();
        readerFuture.get();
        try (Transaction tx = this.db.beginTx();){
            Assert.assertEquals((long)100L, (long)this.db.getNodeById(nodeId).getAllProperties().size());
            tx.success();
        }
    }

    private void createNodeWith(String key) {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            node.setProperty(key, (Object)1);
            tx.success();
        }
    }
}

