/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodePropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.PropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.UniquePropertyConstraintRule;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaCacheTest {
    final SchemaRule hans = this.newIndexRule(1L, 0, 5);
    final SchemaRule witch = this.newIndexRule(2L, 3, 6);
    final SchemaRule gretel = this.newIndexRule(3L, 0, 7);

    @Test
    public void should_construct_schema_cache() {
        List<SchemaRule> rules = Arrays.asList(this.hans, this.witch, this.gretel);
        SchemaCache cache = new SchemaCache((org.neo4j.kernel.impl.constraints.ConstraintSemantics)new StandardConstraintSemantics(), rules);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new SchemaRule[]{this.hans, this.gretel}), (Object)Iterables.asSet((Iterable)cache.schemaRulesForLabel(0)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new SchemaRule[]{this.witch}), (Object)Iterables.asSet((Iterable)cache.schemaRulesForLabel(3)));
        Assert.assertEquals((Object)Iterables.asSet(rules), (Object)Iterables.asSet((Iterable)cache.schemaRules()));
    }

    @Test
    public void should_add_schema_rules_to_a_label() {
        List rules = Collections.emptyList();
        SchemaCache cache = new SchemaCache((org.neo4j.kernel.impl.constraints.ConstraintSemantics)new StandardConstraintSemantics(), rules);
        cache.addSchemaRule(this.hans);
        cache.addSchemaRule(this.gretel);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new SchemaRule[]{this.hans, this.gretel}), (Object)Iterables.asSet((Iterable)cache.schemaRulesForLabel(0)));
    }

    @Test
    public void should_to_retrieve_all_schema_rules() {
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule(this.hans);
        cache.addSchemaRule(this.gretel);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new SchemaRule[]{this.hans, this.gretel}), (Object)Iterables.asSet((Iterable)cache.schemaRules()));
    }

    @Test
    public void should_list_constraints() {
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)UniquePropertyConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)133L));
        cache.addSchemaRule((SchemaRule)UniquePropertyConstraintRule.uniquenessConstraintRule((long)1L, (int)3, (int)4, (long)133L));
        cache.addSchemaRule((SchemaRule)RelationshipPropertyExistenceConstraintRule.relPropertyExistenceConstraintRule((long)2L, (int)5, (int)6));
        cache.addSchemaRule((SchemaRule)NodePropertyExistenceConstraintRule.nodePropertyExistenceConstraintRule((long)3L, (int)7, (int)8));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new PropertyConstraint[]{new UniquenessConstraint(1, 2), new UniquenessConstraint(3, 4), new RelationshipPropertyExistenceConstraint(5, 6), new NodePropertyExistenceConstraint(7, 8)}), (Object)Iterators.asSet((Iterator)cache.constraints()));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new UniquenessConstraint[]{new UniquenessConstraint(1, 2)}), (Object)Iterators.asSet((Iterator)cache.constraintsForLabel(1)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new UniquenessConstraint[]{new UniquenessConstraint(1, 2)}), (Object)Iterators.asSet((Iterator)cache.constraintsForLabelAndProperty(1, 2)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), (Object)Iterators.asSet((Iterator)cache.constraintsForLabelAndProperty(1, 3)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new RelationshipPropertyExistenceConstraint[]{new RelationshipPropertyExistenceConstraint(5, 6)}), (Object)Iterators.asSet((Iterator)cache.constraintsForRelationshipType(5)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new RelationshipPropertyExistenceConstraint[]{new RelationshipPropertyExistenceConstraint(5, 6)}), (Object)Iterators.asSet((Iterator)cache.constraintsForRelationshipTypeAndProperty(5, 6)));
    }

    @Test
    public void should_remove_constraints() {
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)UniquePropertyConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)133L));
        cache.addSchemaRule((SchemaRule)UniquePropertyConstraintRule.uniquenessConstraintRule((long)1L, (int)3, (int)4, (long)133L));
        cache.removeSchemaRule(0L);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new UniquenessConstraint[]{new UniquenessConstraint(3, 4)}), (Object)Iterators.asSet((Iterator)cache.constraints()));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), (Object)Iterators.asSet((Iterator)cache.constraintsForLabel(1)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), (Object)Iterators.asSet((Iterator)cache.constraintsForLabelAndProperty(1, 2)));
    }

    @Test
    public void adding_constraints_should_be_idempotent() throws Exception {
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)UniquePropertyConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)133L));
        cache.addSchemaRule((SchemaRule)UniquePropertyConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)133L));
        Assert.assertEquals(Arrays.asList(new UniquenessConstraint(1, 2)), (Object)Iterators.asList((Iterator)cache.constraints()));
    }

    @Test
    public void shouldResolveIndexDescriptor() throws Exception {
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)this.newIndexRule(1L, 1, 2));
        cache.addSchemaRule((SchemaRule)this.newIndexRule(2L, 1, 3));
        cache.addSchemaRule((SchemaRule)this.newIndexRule(3L, 2, 2));
        IndexDescriptor descriptor = cache.indexDescriptor(1, 3);
        Assert.assertEquals((long)1L, (long)descriptor.getLabelId());
        Assert.assertEquals((long)3L, (long)descriptor.getPropertyKeyId());
    }

    @Test
    public void shouldReturnNullWhenNoIndexExists() {
        SchemaCache schemaCache = SchemaCacheTest.newSchemaCache(new SchemaRule[0]);
        IndexDescriptor indexDescriptor = schemaCache.indexDescriptor(1, 1);
        Assert.assertNull((Object)indexDescriptor);
    }

    @Test
    public void shouldListConstraintsForLabel() {
        UniquePropertyConstraintRule rule1 = UniquePropertyConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)1, (long)0L);
        UniquePropertyConstraintRule rule2 = UniquePropertyConstraintRule.uniquenessConstraintRule((long)1L, (int)2, (int)1, (long)0L);
        NodePropertyExistenceConstraintRule rule3 = NodePropertyExistenceConstraintRule.nodePropertyExistenceConstraintRule((long)2L, (int)1, (int)2);
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[]{rule1, rule2, rule3});
        Set listed = Iterators.asSet((Iterator)cache.constraintsForLabel(1));
        Set expected = Iterators.asSet((Object[])new NodePropertyConstraint[]{rule1.toConstraint(), rule3.toConstraint()});
        Assert.assertEquals((Object)expected, (Object)listed);
    }

    @Test
    public void shouldListConstraintsForLabelAndProperty() {
        UniquePropertyConstraintRule rule1 = UniquePropertyConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)1, (long)0L);
        UniquePropertyConstraintRule rule2 = UniquePropertyConstraintRule.uniquenessConstraintRule((long)1L, (int)2, (int)1, (long)0L);
        NodePropertyExistenceConstraintRule rule3 = NodePropertyExistenceConstraintRule.nodePropertyExistenceConstraintRule((long)2L, (int)1, (int)2);
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[]{rule1, rule2, rule3});
        Set listed = Iterators.asSet((Iterator)cache.constraintsForLabelAndProperty(1, 2));
        Assert.assertEquals(Collections.singleton(rule3.toConstraint()), (Object)listed);
    }

    @Test
    public void shouldListConstraintsForRelationshipType() {
        RelationshipPropertyExistenceConstraintRule rule1 = RelationshipPropertyExistenceConstraintRule.relPropertyExistenceConstraintRule((long)0L, (int)1, (int)1);
        RelationshipPropertyExistenceConstraintRule rule2 = RelationshipPropertyExistenceConstraintRule.relPropertyExistenceConstraintRule((long)0L, (int)2, (int)1);
        RelationshipPropertyExistenceConstraintRule rule3 = RelationshipPropertyExistenceConstraintRule.relPropertyExistenceConstraintRule((long)0L, (int)1, (int)2);
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[]{rule1, rule2, rule3});
        Set listed = Iterators.asSet((Iterator)cache.constraintsForRelationshipType(1));
        Set expected = Iterators.asSet((Object[])new RelationshipPropertyConstraint[]{rule1.toConstraint(), rule3.toConstraint()});
        Assert.assertEquals((Object)expected, (Object)listed);
    }

    @Test
    public void shouldListConstraintsForRelationshipTypeAndProperty() {
        RelationshipPropertyExistenceConstraintRule rule1 = RelationshipPropertyExistenceConstraintRule.relPropertyExistenceConstraintRule((long)0L, (int)1, (int)1);
        RelationshipPropertyExistenceConstraintRule rule2 = RelationshipPropertyExistenceConstraintRule.relPropertyExistenceConstraintRule((long)0L, (int)2, (int)1);
        RelationshipPropertyExistenceConstraintRule rule3 = RelationshipPropertyExistenceConstraintRule.relPropertyExistenceConstraintRule((long)0L, (int)1, (int)2);
        SchemaCache cache = SchemaCacheTest.newSchemaCache(new SchemaRule[]{rule1, rule2, rule3});
        Set listed = Iterators.asSet((Iterator)cache.constraintsForRelationshipTypeAndProperty(2, 1));
        Assert.assertEquals(Collections.singleton(rule2.toConstraint()), (Object)listed);
    }

    private IndexRule newIndexRule(long id, int label, int propertyKey) {
        return IndexRule.indexRule((long)id, (int)label, (int)propertyKey, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
    }

    private static SchemaCache newSchemaCache(SchemaRule ... rules) {
        return new SchemaCache((org.neo4j.kernel.impl.constraints.ConstraintSemantics)new ConstraintSemantics(), rules == null || rules.length == 0 ? Collections.emptyList() : Arrays.asList(rules));
    }

    private static class ConstraintSemantics
    extends StandardConstraintSemantics {
        private ConstraintSemantics() {
        }

        protected PropertyConstraint readNonStandardConstraint(PropertyConstraintRule rule) {
            if (rule instanceof NodePropertyExistenceConstraintRule) {
                return ((NodePropertyExistenceConstraintRule)rule).toConstraint();
            }
            if (rule instanceof RelationshipPropertyExistenceConstraintRule) {
                return ((RelationshipPropertyExistenceConstraintRule)rule).toConstraint();
            }
            return super.readNonStandardConstraint(rule);
        }
    }
}

